/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgDevice.h"
#include "CCentralResources.h"

#include <config.h>

#include <qglobal.h>
#include <QtGui>

#define XSTR(x) STR(x)
#define STR(x) #x

CDlgDevice::CDlgDevice(QWidget * parent)
: QDialog(parent)
{
    setupUi(this);

#if defined(QT_ARCH_WINDOWS)
    //   This is a work around as long as USB doesn't work
    //   I need it for testing
    //   this doesn't work in windows : QStringList files = dir.entryList(QString("*.dll").split(','));

    //    QRegExp regex("(.*)\\.dll");          TODO

    QString pluginPath(gpResources->altPluginPath);
    //    QMessageBox::information(0,"pluginPathpath=",pluginPath);
    //    QMessageBox::information(0,"QL_LIBDIR=",XSTR(QL_LIBDIR));

    //    comboDev->addItem("WinGarmin");
    comboDev->addItem("EtrexVistaHCx");
    comboDev->addItem("GPSMap76CSx");
    comboDev->addItem("GPSMap60CSx");
    comboDev->addItem("GPSMap60Cx");
    comboDev->addItem("GPSMap60");
    comboDev->addItem("EtrexVentureCx");
    comboDev->addItem("EtrexVentureHC");
    comboDev->addItem("EtrexVistaCx");
    comboDev->addItem("NMEATcp");
    comboDev->addItem("infoAboutMyGarmin");
    comboDev->setCurrentIndex(0);

    //  Die folgende Zeile funktioniert nicht, da m_DeviceName zu diesem Zeitpunkt leer ist
    //    QMessageBox::information(0,"gpResources->m_DeviceName=",gpResources->m_DeviceName);
    //    comboDev->setCurrentIndex(comboDev->findText(gpResources->m_DeviceName));

#else                        // !QT_ARCH_WINDOWS
    QRegExp regex("lib(.*)\\" SOEXT);
    QString file;

#if defined(QT_ARCH_MACOSX)
    // MacOS X: plug-ins are stored in the bundle folder
    QDir dir(gpResources->altPluginPath.isEmpty() ?
        QCoreApplication::applicationDirPath().replace(QRegExp("MacOS$"), "Resources/plugins") :
    gpResources->altPluginPath);
    QStringList files = dir.entryList(QString("*" SOEXT).split(','));
#else
    // UNIX: first find plug-ins in the folder defined in the environment
    // or in the build folder
    QDir dir(gpResources->altPluginPath.isEmpty() ?
        QCoreApplication::applicationDirPath() + "/plugins" :
    gpResources->altPluginPath);
    QStringList files = dir.entryList(QString("*" SOEXT).split(','));
    // if nothing is found, look in the standard installation folder
    if (files.isEmpty()) {
        QDir inst_dir(XSTR(QL_LIBDIR));
        files = inst_dir.entryList(QString("*" SOEXT).split(','));
    }
#endif
    foreach(file,files) {
        if(regex.exactMatch(file)) {
            comboDev->addItem(regex.cap(1));
        }
    }
    comboDev->setCurrentIndex(comboDev->findText(gpResources->m_DeviceName));
#endif

    connect(lblLink,SIGNAL(linkActivated(const QString&)),this,SLOT(slotHomepage(const QString&)));
}


CDlgDevice::~CDlgDevice()
{

}


void CDlgDevice::accept()
{
    gpResources->m_DeviceName = comboDev->currentText();

    QDialog::accept();
}


void CDlgDevice::slotHomepage(const QString& link)
{
    gpResources->openLink(link);
}
