/*
 * CSceneTreeRenderer.cpp
 * $Id: CSceneTreeRenderer.cpp,v 1.2 2001/11/15 16:54:51 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Implementation of the example renderer 


/** documentation stuff

  @author Michael Meissner
  
  @version 0.0 //see cvs docu
    
*/


// Own
////////
#include "QGLViewerSceneTreeObjects.h"
#include "CSceneTreeRenderer.h"


// Qt
///////
#include <qapplication.h>
#include <qstring.h>
#include <qgl.h>
#include <qmenubar.h>       // only for the menu
#include <qpopupmenu.h>     // only for the menu

// System
///////////
#include <iostream.h>
#include <math.h>

// defines
////////////
#define SELECT_BUF_SIZE 1024



// Function   : CSceneTreeRenderer
// Parameters :
// Purpose    :
// Comments   :
CSceneTreeRenderer::CSceneTreeRenderer(QGLViewer *pViewer)
          : QSceneTreeRenderer(pViewer)
/******************************************************************/
{
  int i;
  
  m_pViewer = pViewer;

  m_fLeftButtonPressed = m_fMiddleButtonPressed = m_fRightButtonPressed = false;

  m_cSphereCenter[0] = CP3D(0.0, 0.0, 1.0);
  m_cSphereCenter[1] = CP3D(-1.0, 0.0, 0.0);
  m_cSphereCenter[2] = CP3D(1.0, 0.0, 0.0);
  m_cSphereCenter[3] = CP3D(0.0, 0.0, -2.5);
  m_cSphereCenter[4] = CP3D(0.0, -3.0, 0.0);
  m_cSphereCenter[5] = CP3D(-3.5, 0.0, 0.0);
  m_cSphereCenter[6] = CP3D(0.0, 0.0, -1.0);
  m_cSphereCenter[7] = CP3D(0.0, 1.0, 0.0);
  m_cSphereCenter[8] = CP3D(0.0,-1.0, 0.0);
  m_cSphereCenter[9] = CP3D(0.0, 0.0, 2.5);
  m_cSphereCenter[10] = CP3D(0.0, 3.0, 0.0);
  m_cSphereCenter[11] = CP3D(3.5, 0.0, 0.0);

  m_pViewer->makeCurrent();

  CTreeNode *pcNode;

  append(new STQGLViewerBoundingBox(m_pViewer->getCameraPtr()->getBoundingBox()));
  pcNode = append(new STQGLExampleInitNode());
  m_apSphere[0] = static_cast<STQGLExampleSphere *>(
		     pcNode->append(new STQGLExampleWiredSphere(m_cSphereCenter[0], 1.0,16,16,1.0,1.0,0.0)));
  m_apSphere[1] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleWiredSphere(m_cSphereCenter[1], 1.0,16,16,0.0,0.0,1.0)));
  m_apSphere[2] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleWiredSphere(m_cSphereCenter[2], 1.0,16,16,1.0,0.0,1.0)));
  m_apSphere[3] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleWiredSphere(m_cSphereCenter[3], 0.5,8,8,1.0,0.0,0.0)));
  m_apSphere[4] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleWiredSphere(m_cSphereCenter[4], 0.5,8,8,0.0,1.0,0.0)));
  m_apSphere[5] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleWiredSphere(m_cSphereCenter[5], 0.5,8,8,0.0,0.0,1.0)));

  pcNode = pcNode->append(new STLightList(CLightSource(CP3D(-5,0,0), 1.0)));

  m_apSphere[6] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleSolidSphere(m_cSphereCenter[6], 1.0,16,16,.5,.5,1.0)));
  m_apSphere[7] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleSolidSphere(m_cSphereCenter[7], 1.0,16,16,1.0,0.0,0.0)));
  m_apSphere[8] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleSolidSphere(m_cSphereCenter[8], 1.0,16,16,0.0,1.0,0.0)));
  m_apSphere[9] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleSolidSphere(m_cSphereCenter[9], 0.5,8,8,0.0,1.0,1.0)));
  m_apSphere[10] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleSolidSphere(m_cSphereCenter[10], 0.5,8,8,1.0,0.0,1.0)));
  m_apSphere[11] = static_cast<STQGLExampleSphere *>(
                     pcNode->append(new STQGLExampleSolidSphere(m_cSphereCenter[11], 0.5,8,8,1.0,1.0,0.0)));

  return;
}



// Function   : ~CSceneTreeRenderer
// Parameters :
// Purpose    :
// Comments   :
CSceneTreeRenderer::~CSceneTreeRenderer() 
/**************************************************************/
{
}



// Function   : sltCatchKey
// Parameters : int nTmp
// Purpose    :
// Comments   :
void CSceneTreeRenderer::sltCatchKey(int nTmp)
/**************************************************************/
{
  cout << "CSceneTreeRenderer: Caught the signal! It is a " << nTmp;
  cout << " (ascii)" << endl;

  return;
}



// Function   : sltResetSelection
// Parameters : 
// Purpose    : Slot to reset selection
// Comments   :
void CSceneTreeRenderer::sltResetSelection()
/**************************************************************/
{
  int i;

  for (i=0; i<12; i++)
    if (m_apSphere[i]->getViewingMode() == highlighted)
      m_apSphere[i]->setViewingMode(normal);
  
  m_pViewer->sltUpdateView();

  return;
}




// Function   : sltResizeGL
// Parameters :
// Purpose    :
// Comments   : if something special should be done after resizing
void CSceneTreeRenderer::sltResizeGL(int w, int h) 
/**************************************************************/
{
  return;
}



// Function   : sltManageMove
// Parameters :
// Purpose    : 
// Comments   :
void CSceneTreeRenderer::sltManageMove(QMouseEvent *pqEvent) 
/**************************************************************/
{
  int i, nDiffX, nDiffY;
  float rfDistance, rfTransX, rfTransY, rfVTan, rfHTan;
  CCamera *pCamera;
  CP3D cNewCenter;

  if(m_fMiddleButtonPressed) {

    nDiffX = pqEvent->x() - m_nMousePosX;
    nDiffY = m_nMousePosY - pqEvent->y();
    pCamera = m_pViewer->getCameraPtr();

    // save mouse position
    ////////////////////////
    m_nMousePosX = pqEvent->x();
    m_nMousePosY = pqEvent->y();

    // now do the move
    /////////////////////
    for(i=0; i<12; i++) {
      if(m_apSphere[i]->getViewingMode() == highlighted) {
	// calculations just heuristic. Don't really try to understand it.
	rfDistance = (m_cSphereCenter[i] - pCamera->getEyePos()).getNorm();
	rfVTan = tan(pCamera->getFovy()/360.0*M_PI);
	rfHTan = tan((pCamera->getFovy()*pCamera->getRatio()) / 360.0 * M_PI);
	rfTransX = (rfHTan * float(nDiffX)) / m_pViewer->getDrawArea()->width() * rfDistance * 2.1;
	rfTransY = (rfVTan * float(nDiffY)) / m_pViewer->getDrawArea()->height() * rfDistance * 2.1;

	cNewCenter = m_apSphere[i]->getCenter() 
	             + pCamera->getViewRight() * rfTransX
	             + pCamera->getViewUp() * rfTransY;
	if(pCamera->getBoundingBox().isInside(cNewCenter))
	  m_apSphere[i]->setCenter(cNewCenter);
      }
    }

    m_pViewer->sltUpdateView();

  }

  return;
}



// Function   : sltManageSelection
// Parameters :
// Purpose    : 
// Comments   :
void CSceneTreeRenderer::sltManageSelection(QMouseEvent *pqEvent) 
/**************************************************************/
{
  QSceneTreeRenderer::sltManageSelection(pqEvent);

  if (m_nChosen<2)
    return;    // don't manage BBox and init node

  if (m_nChosen>0) {
    m_nChosen -= 2;  // skip BBox and init node
    if (m_nChosen>6)
      --m_nChosen;  // skip light node

    --m_nChosen;  // names are starting from 1 but index from 0

    unsigned int nIndex[12], i, nCounter=0;
    for (i=0; i<12; ++i)
      if (m_apSphere[i]->getViewingMode() != hidden)
	nIndex[nCounter++] = i;

    unsigned int nSphere=nIndex[m_nChosen];

    if (!m_apSphere[nSphere]->event(pqEvent))
      if (m_fLeftButtonPressed)
	if (m_apSphere[nSphere]->getViewingMode() == normal)
	  m_apSphere[nSphere]->setViewingMode(highlighted);
	else if (m_apSphere[nSphere]->getViewingMode() == highlighted)
	  m_apSphere[nSphere]->setViewingMode(normal);
  }

  m_pViewer->sltUpdateView();

  return;
}

