//
// C++ Implementation: splamodel
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "main.h"
#include "splamodel.hpp"
#include "alsound.hpp"
#include "glcontrol.hpp"

QList<splaModel *> splaModel::g_Models;

splaModel::splaModel ( const int id ,FolderListItem *item)
{
    play=0;
    updateme=0;
    miditem = NULL;
    sgZeroCoord ( & pos ) ;
    splaModel::g_Models.append(this);
    handle = splaModel::g_Models.indexOf(this);
    if(id != 0 && item != NULL){
      if((miditem = item->search_id((FolderListItem *)item->treeWidget()->invisibleRootItem(),id)) == NULL){
          qWarning (  "scripting: There is no such 3D Object as '%d'\n", id ) ;
      } else {
        update ( 0 );
      }
   qWarning (  "3D Object as '%d'\n", id ) ;  //debug
    } else {
          qWarning (  "scripting: There is no such 3D Object as '%d'\n", id ) ;
    }
}

splaModel::~splaModel(void)
{
    qWarning ("~splaModel");
}

int splaModel::getHandle () const { return handle ; }

void splaModel::playSound () { play=1; }
void splaModel::stopSound () { play=2; }

float splaModel::getPositionX () const { return pos.xyz[0] ; }
float splaModel::getPositionY () const { return pos.xyz[1] ; }
float splaModel::getPositionZ () const { return pos.xyz[2] ; }
float splaModel::getPositionH () const { return pos.hpr[0] ; }
float splaModel::getPositionP () const { return pos.hpr[1] ; }
float splaModel::getPositionR () const { return pos.hpr[2] ; }

void splaModel::setPosition ( float x, float y, float z, float h, float p, float r )
{
    sgSetCoord ( &pos, x, y, z, h, p, r ) ;
    updateme=1;
}

void splaModel::update ( double dt )
{
    sgMat4 m ;

    ph_mutex.lock();
    if(miditem != NULL ){
      // this code is possible to move to the listviews.cpp
      if(miditem->text(1) == "OBJECT"){
        if(miditem->objtrans != NULL){
          if(updateme==1){
            miditem->objtrans->setTransform ( & pos,miditem->GetValue("scax").toFloat(),miditem->GetValue("scay").toFloat(),miditem->GetValue("scaz").toFloat() ) ;
          }
          miditem->objtrans->getTransform ( m ) ;
          sgSetCoord  ( &pos, m ) ;
        }
      }
      if(miditem->text(1) == "TMPOBJ"){
        if(miditem->objtrans != NULL){
          if(updateme==1){
            miditem->objtrans->setTransform ( & pos,miditem->GetValue("scax").toFloat(),miditem->GetValue("scay").toFloat(),miditem->GetValue("scaz").toFloat() ) ;
          }
          miditem->objtrans->getTransform ( m ) ;
          sgSetCoord  ( &pos, m ) ;
        }
      }
      if(miditem->text(1) == "FIRE"){
        if(miditem->objtrans != NULL){
          if(updateme==1){
            miditem->objtrans->setTransform ( & pos ) ;
          }
          miditem->objtrans->getTransform ( m ) ;
          sgSetCoord  ( &pos, m ) ;
        }
      }
      if(miditem->text(1) == "CAMERA"){
        if(miditem->objtrans != NULL){
          if(updateme==1){
            miditem->objtrans->setTransform ( & pos ) ;
          }
          miditem->objtrans->getTransform ( m ) ;
          sgSetCoord  ( &pos, m ) ;
        }
      }
      if(miditem->text(1) == "BARRIER"){
        if(miditem->barrier != NULL){
          if(updateme==1){
            miditem->barrier->pos.xyz[0] = pos.xyz[0];
            miditem->barrier->pos.xyz[1] = pos.xyz[1];
            miditem->barrier->pos.xyz[2] = pos.xyz[2];

            miditem->barrier->pos.hpr[0] = pos.hpr[0];
            miditem->barrier->pos.hpr[1] = pos.hpr[1];
            miditem->barrier->pos.hpr[2] = pos.hpr[2];
            miditem->barrier->setPosition ();
          }
          miditem->barrier->getPosition (&pos);
        }
      }
      if(miditem->text(1) == "PLAYER"){
        if( miditem->player != NULL){
          if(updateme==1){
            miditem->player->pos.xyz[0] = pos.xyz[0];
            miditem->player->pos.xyz[1] = pos.xyz[1];
            miditem->player->pos.xyz[2] = pos.xyz[2];

            miditem->player->pos.hpr[0] = pos.hpr[0];
            miditem->player->pos.hpr[1] = pos.hpr[1];
            miditem->player->pos.hpr[2] = pos.hpr[2];
            miditem->player->SetPosition ();
          }
          miditem->player->GetPosition (&pos);
        }
      }
      if(miditem->text(1) == "BODY"){
        if(miditem->body != NULL){
          if(updateme==1){
            miditem->body->pos.xyz[0] = pos.xyz[0];
            miditem->body->pos.xyz[1] = pos.xyz[1];
            miditem->body->pos.xyz[2] = pos.xyz[2];

            miditem->body->pos.hpr[0] = pos.hpr[0];
            miditem->body->pos.hpr[1] = pos.hpr[1];
            miditem->body->pos.hpr[2] = pos.hpr[2];
            miditem->body->setPosition ();
          }
          miditem->body->getPosition (&pos);        
        }
      }
      if(miditem->text(1) == "LAMP"){

      }
      if(miditem->text(1) == "CURSOR"){
        if(miditem->cursor != NULL){
          miditem->cursor->getPosition(&pos);
        }
      }
      if(miditem->text(1) == "SOUND"){
        if(miditem->sound != NULL){
          if(updateme==1){
             miditem->sound->setPosition(pos.xyz[0], pos.xyz[1], pos.xyz[2]);
          }
          if(play==1){
            miditem->sound->Play();
            play=0;
          }
          if(play==2){
            miditem->sound->Stop();
            play=0;
          }
        }
      }
      updateme=0;
    }
    ph_mutex.unlock();
}

int splaModel::switchScene()
{
    if(miditem != NULL){
      if(miditem->text(1) == "SCENE"){
        if(g_gl != NULL){
            g_switchScene= miditem;
            g_switch=1;
        }
      }
    }
    return(0);
}

int splaModel::switchCamera()
{
    if(miditem != NULL){
      if(miditem->text(1) == "CAMERA"){
        if(g_gl != NULL){
          ph_mutex.lock();
          g_gl->setFocusCamera(miditem);
          g_gl->switchCamera(miditem);
          ph_mutex.unlock();
        }
      }
    }
    return(0);
}

void splaModel::setAttribute(char *attr, char *value)
{
    if(miditem != NULL){
      if(g_gl != NULL){  // update
         ph_mutex.lock();
         g_gl->changeAttribute(miditem,attr,value);
         ph_mutex.unlock();
      }
    }
}

QString splaModel::getAttribute(char *attr)
{
    QString str;
    int ok=0;
    if(miditem != NULL){
      // this code is possible to move to the listviews.cpp
         if(miditem->text(1) == "CURSOR"){
            if(strstr(attr,"valid") != NULL){
                ph_mutex.lock();
                str.setNum(miditem->cursor->Valid());
                ph_mutex.unlock();
                ok=1;
            }
         }
         if(strstr(attr,"collision") != NULL){
             ph_mutex.lock();
             str.setNum(miditem->collision);
             ph_mutex.unlock();
             ok=1;
         }
         if(strstr(attr,"groundcollision") != NULL){
             ph_mutex.lock();
             str.setNum(miditem->groundcollision);
             ph_mutex.unlock();
             ok=1;
         }
         if(ok != 1){
              ph_mutex.lock();
              str = miditem->GetValue(attr);
              ph_mutex.unlock();
         }
    }
    return(str);
}

FolderListItem * splaModel::getFolderListItem(){
   return(miditem);
}

void splaModel::addRelTorque ( float velx, float vely, float velz )
{
      if(miditem->text(1) == "BODY"){
          ph_mutex.lock();
          miditem->body->lvel[0] = velx;
          miditem->body->lvel[1] = vely;
          miditem->body->lvel[2] = velz;
          miditem->body->addRelTorque ();
          ph_mutex.unlock();
      }
}

void splaModel::setSequence ( int sequenz , int mode )
{
      if(miditem->text(1) == "OBJECT"){
          if(miditem->objtrans-> getKid(0)-> isAKindOf ( ssgTypeSelector() ) ){
              ph_mutex.lock();
              ssgSelector *selector = (ssgSelector *)miditem->objtrans-> getKid(0);
              selector->selectStep ( sequenz );
              if(selector -> getKid(sequenz)-> isAKindOf ( ssgTypeTimedSelector() ) ){
                  ssgTimedSelector *ts = (ssgTimedSelector *)selector -> getKid(sequenz);
                  if(mode == 0)
                    ts -> setMode(SSG_ANIM_SWING);
                  if(mode == 1)
                    ts -> setMode(SSG_ANIM_ONESHOT);
                  if(mode == 2)
                    ts -> setMode(SSG_ANIM_SHUTTLE);
                  ts -> control(SSG_ANIM_START);
                  ts -> setDuration ( 0.1 , -1 , SSG_ANIM_CLOCK ) ;
              } else {
                qWarning ( "qcake: ERROR - OBJECT has no TimedSelector %i !\n",sequenz ) ;
              }
              ph_mutex.unlock();
          } else {
              qWarning ( "qcake: ERROR - OBJECT has no Selector!\n" ) ;
          }
      }
}

void splaModel::setAngularVel ( float velx, float vely, float velz )
{
      if(miditem->text(1) == "BODY"){
          ph_mutex.lock();
          miditem->body->lvel[0] = velx;
          miditem->body->lvel[1] = vely;
          miditem->body->lvel[2] = velz;
          miditem->body->setAngularVel ();
          ph_mutex.unlock();
      }
}

void splaModel::addRelForce ( float velx, float vely, float velz )
{
      if(miditem->text(1) == "BODY"){
          ph_mutex.lock();
          miditem->body->lvel[0] = velx;
          miditem->body->lvel[1] = vely;
          miditem->body->lvel[2] = velz;
          miditem->body->addRelForce ();
          ph_mutex.unlock();
      }
}

void splaModel::setLinVel ( float velx, float vely, float velz )
{
      if(miditem->text(1) == "BODY"){
          ph_mutex.lock();
          miditem->body->lvel[0] = velx;
          miditem->body->lvel[1] = vely;
          miditem->body->lvel[2] = velz;
          miditem->body->setLinearVel ();
          ph_mutex.unlock();
      }
}

void splaModel::setRotation ( float h, float p, float r )
{
      if(miditem->text(1) == "BODY"){
          ph_mutex.lock();
          miditem->body->pos.hpr[0] = h;
          miditem->body->pos.hpr[1] = p;
          miditem->body->pos.hpr[2] = r;
          miditem->body->setRotation ();
          ph_mutex.unlock();
      }
}

void splaModel::Rotation ( float h, float p, float r )
{
    sgMat4 m ;
    sgMat4 mh ;
    
      ph_mutex.lock();
      if(miditem->text(1) == "OBJECT"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        miditem->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        miditem->objtrans->setTransform ( m ) ;    
      }
      if(miditem->text(1) == "TMPOBJ"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        miditem->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        miditem->objtrans->setTransform ( m ) ;    
      }
      if(miditem->text(1) == "BODY"){
          miditem->body->Rotation(h,p,r);
      }
      if(miditem->text(1) == "BARRIER"){
          miditem->barrier->setRotation(h,p,r);
      }
      ph_mutex.unlock();
}
