/***************************************************************************
                          rwidget.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rwidget.cpp 1998/08/24 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rwidget.h"

#include <qapplication.h>


// Constructor:
//
RWidget::RWidget(QWidget* _parent, 
                 const char* _name, 
                 WFlags _f,
                 bool _forwardRightClick,
                 bool _forwardMouseMove)
:QFrame(_parent, _name, _f)
{
  forwardRightClick = _forwardRightClick;
  forwardMouseMove = _forwardMouseMove;
}



// Destructor:
//
RWidget::~RWidget()
{

}


// Forward the right mouse click to parent widget:
//
//   Mouse Release event:
//
void 
RWidget::mouseReleaseEvent(QMouseEvent* _ev)
{
  if(forwardRightClick &&
     (_ev->button()==RightButton ||
      (_ev->button()==LeftButton && (_ev->state()&ControlButton)))) {
    //  || _ev->state()==LeftButton|ControlButton)) {
    //parentWidget()->event(_ev);
    qApp->notify(parentWidget(), _ev);
  }
}



// Forward the mouse moves to parent widget:
//
//   Mouse Move event:
//
void
RWidget::mouseMoveEvent(QMouseEvent* _ev)
{
  if(forwardMouseMove) {
    //parentWidget()->event(_ev);
    qApp->notify(parentWidget(), _ev);
  }
}


// EOF

