/***************************************************************************
                          rsetupedgedecdlg.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rsetupedgedecdlg.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qkeycode.h>
#include <qpushbutton.h>

#include "rlog.h"
#include "rgraphic.h"
#include "rprgdef.h"
#include "rsetupedgedecdlg.h"

// Constructor:
//
RSetupEdgeDecDlg::RSetupEdgeDecDlg(RGraphic* _graphic,
                                   QWidget* _parent,
                                   const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  setFixedSize(320, 230);

  setCaption( tr("Setup edge deceleration") );

  graphic=_graphic;

  QLabel *lab;
  QComboBox *cb;
  
  QGridLayout* gl = new QGridLayout(this, 10, 2, 6, 2);
  for(int i=0; i<=9; ++i) {
    gl->setRowStretch(i, 1);
  }


  // Length:
  lab = new QLabel(tr("Deceleration length:"), this);
  lab->setAlignment(AlignRight|AlignVCenter);
  gl->addWidget(lab, 0, 0);

  cb = new QComboBox( true, this );
  cb->insertItem( "10.0" );
  cb->insertItem( "5.0" );
  cb->insertItem( "2.0" );
  cb->insertItem( "1.0" );
  gl->addWidget(cb, 0, 1);
  cbLength = cb;

  // Steps
  lab = new QLabel(tr("Deceleration steps:"), this);
  lab->setAlignment(AlignRight|AlignVCenter);
  gl->addWidget(lab, 1, 0);

  cb = new QComboBox( true, this );
  cb->insertItem( "1" );
  cb->insertItem( "2" );
  cb->insertItem( "3" );
  gl->addWidget(cb, 1, 1);
  cbSteps = cb;

  // Reduction
  lab = new QLabel(tr("Feedrate reduction:"), this);
  lab->setAlignment(AlignRight|AlignVCenter);
  gl->addWidget(lab, 2, 0);

  cb = new QComboBox( true, this );
  cb->insertItem( "70" );
  cb->insertItem( "60" );
  cb->insertItem( "50" );
  cb->insertItem( "40" );
  cb->insertItem( "30" );
  cb->insertItem( "20" );
  cb->insertItem( "10" );
  gl->addWidget(cb, 2, 1);
  cbReduction = cb;

  // Min Angle
  lab = new QLabel(tr("Don't decelerate if angle bigger than:"), this);
  lab->setAlignment(AlignRight|AlignVCenter);
  gl->addWidget(lab, 3, 0);

  cb = new QComboBox( true, this );
  cb->insertItem( "170" );
  cb->insertItem( "150" );
  cb->insertItem( "120" );
  cb->insertItem( "90" );
  cb->insertItem( "60" );
  cb->insertItem( "30" );
  gl->addWidget(cb, 3, 1);
  cbMinAngle = cb;

  // Acceleration:
  ckbDecBegin = new QCheckBox( tr("Accelerate at element start"), this );
  ckbDecBegin->setFixedSize( 240, 20 );
  gl->addMultiCellWidget(ckbDecBegin, 4,4, 0,1, AlignRight);

  // Deceleration:
  ckbDecEnd = new QCheckBox( tr("Decelerate at element end"), this );
  ckbDecEnd->setFixedSize( 240, 20 );
  gl->addMultiCellWidget(ckbDecEnd, 5,5, 0,1, AlignRight);

  // Contour Acceleration:
  ckbDecContBegin = new QCheckBox( tr("Accelerate at contour start"), this );
  ckbDecContBegin->setFixedSize( 240, 20 );
  gl->addMultiCellWidget(ckbDecContBegin, 6,6, 0,1, AlignRight);

  // Contour Deceleration:
  ckbDecContEnd = new QCheckBox( tr("Decelerate at contour end"), this );
  ckbDecContEnd->setFixedSize( 240, 20 );
  gl->addMultiCellWidget(ckbDecContEnd, 7,7, 0,1, AlignRight);

  // OK
  bOk = new QPushButton( tr("Ok"), this );
  bOk->setAccel(Key_Return);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));
  bOk->setGeometry( width()-205,height()-30, 100,22  );

  // Cancel
  bCancel = new QPushButton( tr("Cancel"), this );
  bCancel->setAccel(Key_Escape);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
  bCancel->setGeometry( width()-105,height()-30, 100,22  );

  init();
}



// Destructor:
//
RSetupEdgeDecDlg::~RSetupEdgeDecDlg()
{

}


/** Show and initialize */
void
RSetupEdgeDecDlg::show()
{
  init();
  QDialog::show();
}


/** Initialize */
void
RSetupEdgeDecDlg::init()
{
  if( graphic ) {
    QString str;
    cbLength->setEditText( str.setNum(graphic->getDecLength()) );
    cbSteps->setEditText( str.setNum(graphic->getDecSteps()) );
    cbReduction->setEditText( str.setNum(graphic->getDecReduction()) );
    cbMinAngle->setEditText( str.setNum(graphic->getDecMinAngle()) );
    ckbDecBegin->setChecked( graphic->getDecBegin() );
    ckbDecEnd->setChecked( graphic->getDecEnd() );
    ckbDecContBegin->setChecked( graphic->getDecContBegin() );
    ckbDecContEnd->setChecked( graphic->getDecContEnd() );
  }
}


// Accept:
//
void
RSetupEdgeDecDlg::accept()
{
  saveValues();
  QDialog::accept();
}


// Saves values to graphic
//
void
RSetupEdgeDecDlg::saveValues()
{
  if( graphic ) {
    graphic->setDecLength( cbLength->currentText().toDouble() );
    graphic->setDecSteps( cbSteps->currentText().toInt() );
    graphic->setDecReduction( cbReduction->currentText().toDouble() );
    graphic->setDecMinAngle( cbMinAngle->currentText().toDouble() );
    graphic->setDecEnd( ckbDecEnd->isChecked() );
    graphic->setDecBegin( ckbDecBegin->isChecked() );
    graphic->setDecContEnd( ckbDecContEnd->isChecked() );
    graphic->setDecContBegin( ckbDecContBegin->isChecked() );
  }
}

// EOF



