/***************************************************************************
                          dgnelemtypes.h  -  description
                             -------------------
    begin                : Thu Dec 23 1999
    copyright            : (C) 1999 by Jan Van Sweevelt
    email                : jan-vansweevelt@freegates.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This file contains all 2d elementtypes as described by Intergraph     *
 *   Some are still commented out as I'm not sure how to implement them    *
 *   or if they are needed                                                 *
 *                                                                         *
 ***************************************************************************/
/*----------------------------------------------------------------------+
|                                                                       |
|   TypeDescription                                                     |
/                                                                       /
|    1               Cell Library Header                                |
|    2               Cell (complex)                                     |
|    3               Line                                               |
|    4               Line String                                        |
|    5               Group Data                                         |
|    6               Shape                                              |
|    7               Text Node (complex)                                |
|    8               Digitizer Setup Data                               |
|    9               Design File Header                                 |
|    10              Level Symbology                                    |
|    11              Curve                                              |
|    12              Complex String (complex)                           |
|    13              Conic                                              |
|    14              Complex Shape (complex)                            |
|    15              Ellipse                                            |
|    16              Arc                                                |
|    17              Text                                               |
|    18              Surface (complex)                                  |
|    19              Solid (complex)                                    |
|    20              not used                                           |
|    21              B-Spline Pole                                      |
|    22              Point String                                       |
|    23              Circular Truncated Cone                            |
|    24              B-Spline Surface (complex)                         |
|    25              B-Spline Surface boundary                          |
|    26              B-Spline Knot Element                              |
|    27              B-Spline Curve (complex)                           |
|    28              B-Spline Weight Factor                             |
|    33              Dimension Element                                  |
|    34              Shared Cell Definition Element                     |
|    35              Shared Cell Element                                |
|    36              Multiline Element                                  |
|    37              Attribute Element                                  |
|    66              MicroStation Application                           |
|    87              Raster Header                                      |
|    88              Raster Component                                   |
|    90              Raster Reference Attachment                        |
|                                                                       |
+----------------------------------------------------------------------*/
#define    CELL_LIB_DGNELM             1
#define    CELL_HEADER_DGNELM          2
#define    LINE_DGNELM                 3
#define    LINE_STRING_DGNELM          4
#define    GROUP_DATA_DGNELM           5
#define    SHAPE_DGNELM                6
#define    TEXT_NODE_DGNELM            7
#define    DIG_SETDATA_DGNELM          8
#define    DGNFIL_HEADER_DGNELM        9
#define    LEV_SYM_DGNELM             10
#define    CURVE_DGNELM               11
#define    CMPLX_STRING_DGNELM        12
#define    CONIC_DGNELM               13
#define    CMPLX_SHAPE_DGNELM         14
#define    ELLIPSE_DGNELM             15
#define    ARC_DGNELM                 16
#define    TEXT_DGNELM                17
#define    SURFACE_DGNELM             18
#define    SOLID_DGNELM               19
#define    BSPLINE_POLE_DGNELM        21
#define    POINT_STRING_DGNELM        22
#define    CONE_DGNELM                23
#define    BSPLINE_SURFACE_DGNELM     24
#define    BSURF_BOUNDARY_DGNELM      25
#define    BSPLINE_KNOT_DGNELM        26
#define    BSPLINE_CURVE_DGNELM       27
#define    BSPLINE_WEIGHT_DGNELM      28
#define    DIMENSION_DGNELM           33
#define    SHAREDCELL_DEF_DGNELM      34
#define    SHARED_CELL_DGNELM         35
#define    MULTILINE_DGNELM           36
#define    ATTRIBUTE_DGNELM           37
#define    BREP_DGNELM                38
#define    MICROSTATION_DGNELM        66
#define    RASTER_DGNHDR              87
#define    RASTER_DGNCOMP             88
#define    RASTER_REFERENCE_DGNELM    90

#define DGNELM_HDR_SIZE 28
#define DGNELM_PRP_SIZE 8

/* Structure to help conversion from dgn int's to linux c++ int's*/
typedef struct dgnint
{
unsigned short highi;           //Lower part of integer
unsigned short lowi;          //Higher part of integer
} DGNInt;

/* Macro to switch low and high part of Microstation int's */
#define SWITCHINT(CO, DGNINT) CO=DGNINT.highi << 16; \
                              CO|=DGNINT.lowi

typedef struct point2d
{
DGNInt    x;
DGNInt    y;
} Point2d;

typedef struct dpoint2d
{
double  x;
double  y;
} Dpoint2d;

typedef struct lTrans2d
{
long    t11;
long    t12;
long    t21;
long    t22;
} LTrans2d;

/* Header structure for a DGN element */
typedef struct elm_hdr
    {
    unsigned short  level:6;       /* level element is on */
    unsigned short  reserved:1;    /* reserved by Intergraph */
    unsigned short  complex:1;     /* part of complex element (cell) if set */
    unsigned short  type:7;        /* type of element */
    unsigned short  deleted:1;     /* set if element is deleted */

    unsigned short  words;         /* number of words to follow in element */
             DGNInt xlow;          /* range of element - low (reversed longs) */
             DGNInt ylow;
             DGNInt zlow;
             DGNInt xhigh;         /* range of element - high (reversed longs) */
             DGNInt yhigh;
             DGNInt zhigh;
    } DGNElm_hdr;

/* DGN Element properties */

typedef struct properties
    {
    unsigned char DGNclass:4;    /* element class */
    unsigned char :4;         /* reserved by Intergraph */
    unsigned char l:1;        /* locked */
    unsigned char n:1;        /* new */
    unsigned char m:1;        /* modified */
    unsigned char a:1;        /* attributes present */
    unsigned char r:1;        /* relative to: 0=database 1=screen */
    unsigned char p:1;        /* planar */
    unsigned char s:1;        /* 0=snappable, 1=nonsnappable */
    unsigned char h:1;        /* hole or solid (usually) */
    } DGNProperties;

/* DGN Element symbology */

typedef struct symbology
{
   unsigned short style:3;/* element line style */
   unsigned short weight:5;/* current line weight */
   unsigned short color:8;/* current color */
//    PAD_BITS_IF_NEEDED(16)
} DGNSymbology;/* element symbology word */

/* DGN Element Display Header */

typedef struct disp_hdr
{
unsigned short  grphgrp;/* graphics group number */
short    attindx;/* words between this and attribute linkage */

DGNProperties  p;

DGNSymbology   s;

} DGNDisp_hdr;

/* DGN Element Header */

typedef struct header
{
    DGNElm_hdr    ehdr;
    DGNDisp_hdr    dhdr;
} DGNHeader;

/* DGN Cell Library header */
typedef struct cell_lib_hdr
{
    DGNElm_hdr    ehdr;          /* element header */
    short    celltype;           /* cell type */
    short    attindx;            /* attribute linkage */
    long    name;                /* radix-50 cell name */
    unsigned short  numwords;    /* number of words in descriptions */
    short    properties;         /* properties */
    short    dispsymb;           /* display symbology */
    short    DGNclass;              /* cell class (always 0) */
    short    levels[4];          /* levels used in cell */
    short    descrip[9];         /* cell description */
} DGNCell_Lib_Hdr;

/* 2d DGN Cell element */
typedef struct cell_2d
{
    DGNElm_hdr    ehdr;           /* element header */
    DGNDisp_hdr    dhdr;          /* display header */
    unsigned short  totlength;    /* total length of cell */
    long    name;                 /* radix 50 name */
    short    DGNclass;               /* class bit map */
    short    levels[4];           /* levels used in cell */
    Point2d    rnglow;            /* range block lo */
    Point2d    rnghigh;           /* range block hi */
    LTrans2d    trans;            /* transformation matrix */
    Point2d    origin;            /* cell origin */
} DGNCell_2d;

/* 2d Line element */

typedef struct line_2d
{
    Point2d     start;    /* starting point */
    Point2d     end;      /* ending point */
} DGNLine_2d;

/*----------------------------------------------------------------------+
||
|   2-D Line String Element (type 4)|
||
|   Same structure represents 2-D Shape Elements (type 6), 2-D Curve|
|   Elements (type 11), and 2-D Conic Elements (type 13).  Shapes differ|
|   from line strings in that shape elements always start and end at|
|   the same point.  Curve and conic elements use the first and last    |
|   vertices to establish the slope at the beginning and end.|
||
+----------------------------------------------------------------------*/
typedef struct line_string_2d
{
    short        numverts;/* number of vertices */
//    Point2d      vertice[1];/* points */
} DGNLine_String_2d;

/*----------------------------------------------------------------------+
||
|   Reference File Attachment Element (type 5, level 9)|
||
+----------------------------------------------------------------------*/
//typedef struct ref_file_type5
//    {
//    Elm_hdr   ehdr;    /* element header */
//    Disp_hdr  dhdr;    /* display header */
//    short     file_chars;    /* number of characters in file spec */
//    char      file_spec[65];    /* file specification */
//    byte      file_num;    /* file number */
//    Fb_opts   fb_opts;    /* file builder options mask */
//    Fd_opts   fd_opts;    /* file displayer options mask */
//    byte      disp_flags[16];    /* display flags */
//    short     lev_flags[8][4];    /* level on/of flags */
//    long      ref_org[3];    /* origin in reference file uors */
//    double    trns_mtrx[9];    /* transformation matrix */
//    double    cnvrs_fact;    /* conversion factor */
//    long      mast_org[3];    /* origin in master file uors */
//    short     log_chars;    /* characters in logical name */
//    char      log_name[22];    /* logical name (padded) */
//    short     desc_chars;    /* characters in description */
//    char      description[42];    /* description (padded) */
//    short     lev_sym_mask;    /* level symbology enable mask */
//    short     lev_sym[63];    /* level symbology descriptor */
//    long      z_delta;    /* Z-direction delta */
//    short     clip_vertices;    /* clipping vertices */
//    Point2d   clip_poly[1];    /* clipping polygon */
//    } Ref_file_type5;


/*----------------------------------------------------------------------+
||
|   Color table element (type 5, level 1)|
||
+----------------------------------------------------------------------*/
//typedef struct color_table_type5
//    {
//    Elm_hdr  ehdr;/* element header */
//    Disp_hdr dhdr;/* display header */
//    short    screen_flag;/* screen flag */
//    byte     color_info[1];  /* color table information */
//    } Color_table_type5;

/*----------------------------------------------------------------------+
||
|   short pattern (type 5, level 0)|
||
+----------------------------------------------------------------------*/
//typedef struct short_pattern_type5
//    {
//    Elm_hdr ehdr;/* element header */
//    Disp_hdr dhdr;/* display header */
//    short   indicator;
//    long name;
//    double scale;
//    double angle;
//    long   row_spacing;
//    long   column_spacing;
//    } Short_pattern_type5;

/*----------------------------------------------------------------------+
||
|   long pattern (type 5, level 0)|
||
+----------------------------------------------------------------------*/
//typedef struct long_pattern_type5
//    {
//    Elm_hdr    ehdr;/* element header */
//    Disp_hdr    dhdr;/* display header */
//    short    indicator;
//    long    name;
//    double    scale;
//    double    angle;
//    long    row_spacing;
//    long    column_spacing;
//    Seven_wd_lknm   library;/* file spec */
//    Symbology    symbology;
//    short    fbfdcn;
//    byte    master_type;
//    byte    request_type;
//    Point2d    idpoint;
//    Point2d    accpoint;
//    } Long_pattern_type5;

/*----------------------------------------------------------------------+
||
|   Auxilliary Coordinate System (type 5, level 3)|
||
+----------------------------------------------------------------------*/

//typedef struct aux_coordinate
//    {
//    Elm_hdr  ehdr;    /* element hdr (origin stored in range) */
//    short grphgrp;    /* graphics group number */
//    short attindx;    /* words between this and attrb linkage */
//    short properties;    /* property bits (always the same) */
//    unsigned short type:3;    /* number of views */
//    unsigned short reserved:13;  /* reserved for Intergraph */
//    char description[18];    /* definition description */
//    double trans[3][3];
//    short attribute;    /* 0001000000000011 */
//    short user_id;    /* always 22 */
//    long name;    /* 6 characters stored RAD50 */
//    } Aux_coordinate;

/* 2-D Text Node Element (complex element, type 7) */

//typedef struct text_node_2d
//{
//    DGNElm_hdr    ehdr;           /* element header */
//    DGNDisp_hdr    dhdr;          /* display header */
//    unsigned short  totwords;     /* total words following (cmplx ele) */
//    short    numstrngs;           /* number of text strings in node */
//    unsigned short  nodenumber;   /* text node number */
//    byte    maxlngth;             /* maximum length allowed */
//    byte    maxused;              /* maximum length used */
//    byte    font;                 /* text font used */
//    byte    just;                 /* justification type */
//    long    linespc;              /* line spacing */
//    long    lngthmult;            /* length multiplier */
//    long    hghtmult;             /* height multiplier */
//    long    rotation;             /* rotation angle */
//    Point2d    origin;            /* origin */
//} DGNText_node_2d;


/* Design file header */

typedef struct dgn_header
    {
    DGNElm_hdr    ehdr;    /* element header */
    short    tcbinfo[1];    /* tcb information */
    } DGN_header;

/*----------------------------------------------------------------------+
||
|    Complex string (type 12, complex)|
||
+----------------------------------------------------------------------*/
//typedef struct complex_string
//    {
//    Elm_hdr    ehdr;    /* element header */
//    Disp_hdr    dhdr;    /* display header */
//    unsigned short  totlength;    /* total length of surface */
//    unsigned short  numelems;    /* number of elements in surface */
//    short    attributes[4];  /* to reach minimum elem size */
//    } Complex_string;


/* 2-D Ellipse Element */

typedef struct ellipse_2d
    {
    DGNElm_hdr    ehdr;     /* element header */
    DGNDisp_hdr    dhdr;    /* display header */
    double    primary;      /* primary axis */
    double    secondary;    /* secondary axis */
    long    rotation;       /* rotation angle */
    Dpoint2d    origin;     /* origin */
    } DGNEllipse_2d;

/* 2-D Arc Element */

typedef struct arc_2d
    {
    DGNElm_hdr     ehdr;
    DGNDisp_hdr    dhdr;
    long           startang;     /* start angle */
    long           sweepang;     /* sweep angle */
    double         primary;      /* primary axis */
    double         secondary;    /* secondary axis */
    long           rotation;     /* rotation angle */
    Dpoint2d       origin;       /* origin */
    } DGNArc_2d;

/* 2-D Text Element */

typedef struct text_2d
    {
    DGNElm_hdr    ehdr;     /* element header */
    DGNDisp_hdr    dhdr;    /* display header */
    char    font;           /* text font used */
    char    just;           /* justification type */
    long    lngthmult;      /* length multiplier */
    long    hghtmult;       /* height multiplier */
    long    rotation;       /* rotation angle */
    Point2d    origin;      /* origin */
    char    numchars;       /* # of characters */
    char    edflds;         /* # of enter data fields */
    char    string[2];      /* characters */
    } DGNText_2d;


/* 2-D  B-Spline pole element (type 21) */
typedef struct bspline_poles_2d
    {
    DGNElm_hdr    ehdr;    /* element header */
    DGNDisp_hdr    dhdr;    /* display header */
    short    numpoles;    /* number of poles */
    Point2d    poles[1];    /* points */
    } DGNBspline_pole_2d;

/* 2-D Point String element (type 22) */

typedef struct point_string_2d
    {
    DGNElm_hdr ehdr;           /* element header */
    DGNDisp_hdr dhdr;          /* display header */
    short numpts;         /* number of  points */
    Point2d point[1];     /* points */
    } Point_string_2d;

/* Raster Flags structure */
//typedef union raster_flags
//{
//struct
//{
//   unsigned    right:1;
//   unsigned    lower:1;
//   unsigned    horizontal:1;
//   unsigned    format:5;
//   unsigned    color:1;
//   unsigned    transparent:1;
//   unsigned    positive:1;
//   unsigned    unused:5;
//   PAD_BITS_IF_NEEDED(16)
//} b;
//short s;
//} Raster_flags;

/* Raster header element (type 87) */
//typedef struct raster_hdr
//    {
//    Elm_hdr    ehdr;    /* element header */
//    Disp_hdr    dhdr;    /* display header */
//    ULong    totlength;    /* total length of cell */
//    Raster_flags    flags;    /* miscellaneous raster data */
//    byte    background;
//    byte    foreground;
//    UShort    xextent;
//    UShort    yextent;
//    short    reserved[2];
//    double    resolution;
//    double    scale;
//    Point3d    origin;
//    UShort    numverts;
//    union
//{
//Point2d    vert2d[1];
//Point3d    vert3d[1];
//} u;
//    } Raster_hdr;

/* Raster component (type 88) */

//typedef struct raster_comp
//    {
//    Elm_hdr    ehdr;    /* element header */
//    Disp_hdr    dhdr;    /* display header */
//    Raster_flags    flags;    /* flags */
//    byte    background;
//    byte    foreground;
//    UShort    xoffset;
//    UShort    yoffset;
//    UShort    numpixels;
//    byte    pixel[1];
//    } Raster_comp;








