/***************************************************************************
  calcresource.h
  -------------------
  Resources for QBrewCalc class
  -------------------
  begin         September 26th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef CALCRESOURCE_H
#define CALCRESOURCE_H

#include <qstring.h>

namespace CalcResource {

// previous compatible file format, largely meaningless until release is semi-stable
const QString CALC_PREVIOUS        = "0.1.7";

//////////////////////////////////////////////////////////////////////////////
// File Names

const QString ID_DATA_DIR           = "data/";
const QString ID_OLD_CALC_FILE      = "calcdb";
const QString ID_CALC_FILE          = "qbrewdata";

//////////////////////////////////////////////////////////////////////////////
// XML Format Strings

const QString tagDoc                = "qbrewdata";
const QString attrVersion           = "version";
const QString tagStyles             = "styles";
const QString tagStyle              = "style";
const QString attrOGLow             = "oglow";
const QString attrOGHigh            = "oghigh";
const QString attrIBULow            = "ibulow";
const QString attrIBUHigh           = "ibuhigh";
const QString attrSRMLow            = "srmlow";
const QString attrSRMHigh           = "srmhigh";
const QString tagGrains             = "grains";
const QString tagGrain              = "grain";
const QString attrQuantity          = "quantity";
const QString attrExtract           = "extract";
const QString attrColor             = "color";
const QString attrUse               = "use";
const QString tagHops               = "hops";
const QString tagHop                = "hop";
const QString attrForm              = "form";
const QString attrAlpha             = "alpha";
const QString attrTime              = "time";
const QString tagMiscIngredients    = "miscingredients";
const QString tagMiscIngredient     = "miscingredient";
const QString attrNotes             = "notes";
const QString tagUtilization        = "utilization";
const QString tagEntry              = "entry";
const QString attrUtil              = "util";

// group types to build hash with
const QString groupStyles           = "STYLES";
const int gidStyles                 = 10010;
const QString groupCalcGrains       = "GRAINS";
const int gidCalcGrains             = 10011;
const QString groupCalcHops         = "HOPS";
const int gidCalcHops               = 10012;
const QString groupCalcMisc         = "MISC";
const int gidCalcMisc               = 10013;
const QString groupUtilTable        = "UTILIZATIONS";
const int gidUtilTable              = 10014;

// constants for conversion
const QString CALC_OLDFORMAT        = "QBREWCALC";
const QString CALC_OLDVERSION       = "0.0";
const QString CALC_OLDPREVIOUS      = "0.0";

} // CalcResource

#endif // CALCRESOURCE_H
