/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef QBANKMANAGER_CATEGORYREPORT_H
#define QBANKMANAGER_CATEGORYREPORT_H


#include "report.h"

#include <aqbanking/value.h>


class CategoryReport: public Report {
protected:
  QString handleCategory(GWEN_DB_NODE *dbProfile,
                         QWidget *parent,
                         CategoryData *cd);
  QString handleTransaction(GWEN_DB_NODE *dbProfile,
                            QWidget *parent,
                            RefPointer<Transaction> t);
  QString handleMonth(GWEN_DB_NODE *dbProfile,
                      QWidget *parent,
                      Month *m);

  CategoryData *_findCategoryData(std::list<CategoryData*> &cdl,
                                  const char *id);

  QString _handleRealCategory(GWEN_DB_NODE *dbProfile,
                              QWidget *parent,
                              std::list<CategoryData*> cdl,
                              Category *cat,
                              AB_VALUE *val,
                              int level);

public:
  CategoryReport(KBanking *app);
  ~CategoryReport();

  QString shortDescription();
  QString longDescription();

  bool initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  bool editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  bool useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);

};



#endif // QBANKMANAGER_SIMPLEREPORT_H

