/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: textmatcher.cpp 329 2005-09-20 13:35:49Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "textmatcher.h"
#include "app.h"

#include <qbanking/qbanking.h>

#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>



TextMatcher::TextMatcher(QWidget* parent,
                         const char* name,
                         WFlags fl)
:TextMatcherUi(parent, name, fl){
}



TextMatcher::~TextMatcher() {
}



void TextMatcher::setLabel(const QString &text) {
  action1Label->setText(text);
  action2Label->setText(text);
  action3Label->setText(text);
}



bool TextMatcher::fromDb(GWEN_DB_NODE *db) {
  GWEN_DB_NODE *dbR;
  int i;

  dbR=GWEN_DB_FindFirstGroup(db, "compare");
  if (GWEN_DB_GetIntValue(db, "allMustMatch", 0, 0)) {
    allMustMatchRadio->setChecked(true);
    oneMustMatchRadio->setChecked(false);
  }
  else {
    allMustMatchRadio->setChecked(false);
    oneMustMatchRadio->setChecked(true);
  }

  i=1;
  while(dbR) {
    TEXTMATCHER_OPERATION op;
    const char *s;

    s=GWEN_DB_GetCharValue(dbR, "operation", 0, 0);
    if (s) {
      op=App::string2TextMatcherOperation(s);
      if (op==TextMatcherOperation_Unknown)
	op=TextMatcherOperation_Contains;
      s=GWEN_DB_GetCharValue(dbR, "argument", 0, 0);
      if (s) {
	switch(i) {
	case 1:
	  action1Combo->setCurrentItem(op);
	  action1Edit->setText(QString::fromUtf8(s));
	  break;
	case 2:
	  action2Combo->setCurrentItem(op);
	  action2Edit->setText(QString::fromUtf8(s));
	  break;
	case 3:
	  action3Combo->setCurrentItem(op);
	  action3Edit->setText(QString::fromUtf8(s));
	  break;
	default:
	  DBG_ERROR(0, "Ignoring extra rule %d", i);
	  i--;
	}
	i++;
      }
    }
    dbR=GWEN_DB_FindNextGroup(dbR, "compare");
  }

  return true;
}



bool TextMatcher::toDb(GWEN_DB_NODE *db) const {
  std::string s;
  GWEN_DB_NODE *dbR;
  TEXTMATCHER_OPERATION op;

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "allMustMatch",
                      (allMustMatchRadio->isOn()));

  s=QBanking::QStringToUtf8String(action1Edit->text());
  if (s.empty())
    return true;
  dbR=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_CREATE_GROUP, "compare");
  assert(dbR);
  op=(TEXTMATCHER_OPERATION)action1Combo->currentItem();
  GWEN_DB_SetCharValue(dbR, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "operation",
                       App::textMatcherOperation2String(op));
  GWEN_DB_SetCharValue(dbR, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "argument",
                       s.c_str());

  s=QBanking::QStringToUtf8String(action2Edit->text());
  if (s.empty())
    return true;
  dbR=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_CREATE_GROUP, "compare");
  assert(dbR);
  op=(TEXTMATCHER_OPERATION)action2Combo->currentItem();
  GWEN_DB_SetCharValue(dbR, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "operation",
                       App::textMatcherOperation2String(op));
  GWEN_DB_SetCharValue(dbR, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "argument",
                       s.c_str());

  s=QBanking::QStringToUtf8String(action3Edit->text());
  if (s.empty())
    return true;
  dbR=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_CREATE_GROUP, "compare");
  assert(dbR);
  op=(TEXTMATCHER_OPERATION)action3Combo->currentItem();
  GWEN_DB_SetCharValue(dbR, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "operation",
                       App::textMatcherOperation2String(op));
  GWEN_DB_SetCharValue(dbR, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "argument",
                       s.c_str());

  return true;
}



void TextMatcher::resetRule() {
  allMustMatchRadio->setChecked(false);
  oneMustMatchRadio->setChecked(true);
  action1Combo->setCurrentItem(TextMatcherOperation_Contains);
  action1Edit->setText(QString::null);
  action2Combo->setCurrentItem(TextMatcherOperation_Contains);
  action2Edit->setText(QString::null);
  action3Combo->setCurrentItem(TextMatcherOperation_Contains);
  action3Edit->setText(QString::null);
}



