/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: transactionwindow.h 277 2005-08-24 16:52:02Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifndef KBANKING_TRANSACTIONWINDOW_H
#define KBANKING_TRANSACTIONWINDOW_H


#include <qwidget.h>
#include <qstatusbar.h>
#include <qlabel.h>


class TransactionWindow;
class KBanking;
class Account;

#include "transactionview.h"


class TransactionWindow: public QWidget {
  Q_OBJECT
public:
  TransactionWindow(Account *a,
                    QWidget* parent=0,
                    const char* name=0,
                    WFlags fl=0);
  TransactionWindow(KBanking *app,
                    const std::list<RefPointer<Transaction> > &l,
                    const char *tname=0,
                    QWidget* parent=0,
                    const char* name=0,
                    WFlags fl=0);
  ~TransactionWindow();

  bool init();
  bool fini();

protected:
  void closeEvent(QCloseEvent *e);

public slots:
  void slotUpdated();

private:
  KBanking *_app;
  Account *_account;
  QStatusBar *_statusBar;
  QLabel *_balance;
  TransactionView *_transactionView;
  const char *_tname;
};




#endif

