/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: settings.cpp 337 2005-11-25 16:49:41Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "settings.h"
#include <qbanking/qbprocesswatcher.h>
#include <qbanking/qbplugindescrlist.h>
#include "kbanking.h"

#include <qwidget.h>
#include <qgroupbox.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qfile.h>
#include <qprocess.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>

#include <aqbanking/provider.h>

#include <gwenhywfar/debug.h>


// DEBUG
#include <aqbanking/jobgetbalance.h>
#include <aqbanking/jobgettransactions.h>




KBankingSettings::KBankingSettings(KBanking *ab,
                                   QWidget* parent,
                                   const char* name,
                                   WFlags fl)
:KBankingSettingsUi(parent, name, fl), _banking(ab) {
  GWEN_DB_NODE *dbSettings;

  dbSettings=ab->getAppData();
  assert(dbSettings);
  dbSettings=GWEN_DB_GetGroup(dbSettings, GWEN_DB_FLAGS_DEFAULT,
                              "bankingSettings");
  assert(dbSettings);

  // Manually create and add layout here because the .ui-generated
  // QGroupBox doesn't have one.
  backendsBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *backendsBoxLayout = new QHBoxLayout( backendsBox->layout() );
  backendsBoxLayout->setAlignment( Qt::AlignTop );

  _providerListView=new QBPluginDescrListView(backendsBox,
                                              "BackendList");
  backendsBoxLayout->addWidget(_providerListView);

  /* connect buttons to actions */
  QObject::connect(closeButton, SIGNAL(clicked()),
                   this, SLOT(accept()));

  QObject::connect(backendRescanButton, SIGNAL(clicked()),
                   this, SLOT(backendRescan()));

  QObject::connect(backendEnableButton, SIGNAL(clicked()),
                   this, SLOT(backendEnable()));
  QObject::connect(backendDisableButton, SIGNAL(clicked()),
                   this, SLOT(backendDisable()));

  QObject::connect(backendSetupButton, SIGNAL(clicked()),
                   this, SLOT(backendSetup()));

}



KBankingSettings::~KBankingSettings(){
}



int KBankingSettings::init(){
  GWEN_DB_NODE *db;

  db=_banking->getAppData();
  assert(db);

  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                      "gui/dlgs/settings");
  if (db) {
    int i, j;

    /* setup provider list view */
    for (i=0; i<_providerListView->columns(); i++) {
      _providerListView->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(db, "providerList/columns", i, -1);
      if (j!=-1)
        _providerListView->setColumnWidth(i, j);
    } /* for */
  } /* if settings */
  _providerListView->setSelectionMode(QListView::Single);

  _providerListView->addPluginDescrs(_banking->getProviderDescrs());

  autoAssignPayeeCheck->setChecked(_banking->optionAutoAssignPayee());
  autoAskPayeeCheck->setChecked(_banking->optionAutoAskForPayee());

  normalThresholdSpin->setValue(_banking->getFuzzyThreshold());
  sensitiveThresholdSpin->setValue(_banking->getSensitiveFuzzyThreshold());

  autoAssignCategoryCheck->setChecked(_banking->optionAutoAssignCategory());
  autoAskCategoryCheck->setChecked(_banking->optionAutoAskForCategory());

  useColoursForCategoryTextCheck->setChecked(_banking
                                             ->useColoursForCategoryText());

  return 0;
}



int KBankingSettings::fini(){
  GWEN_DB_NODE *dbSettings;
  int i, j;

  dbSettings=_banking->getAppData();
  assert(dbSettings);
  dbSettings=GWEN_DB_GetGroup(dbSettings, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                              "gui/dlgs/settings/");
  assert(dbSettings);

  /* save provider list view settings */
  GWEN_DB_DeleteVar(dbSettings, "providerList/columns");
  for (i=0; i<_providerListView->columns(); i++) {
    j=_providerListView->columnWidth(i);
    GWEN_DB_SetIntValue(dbSettings, GWEN_DB_FLAGS_DEFAULT,
                        "providerList/columns", j);
  } /* for */

  _banking->setOptionAutoAssignPayee(autoAssignPayeeCheck->isChecked());
  _banking->setOptionAutoAskForPayee(autoAskPayeeCheck->isChecked());

  _banking->setFuzzyThreshold(normalThresholdSpin->value());
  _banking->setSensitiveFuzzyThreshold(sensitiveThresholdSpin->value());

  _banking->setOptionAutoAssignCategory(autoAssignCategoryCheck->isChecked());
  _banking->setOptionAutoAskForCategory(autoAskCategoryCheck->isChecked());
  _banking->setUseColoursForCategoryText(useColoursForCategoryTextCheck
                                         ->isChecked());

  _banking->flagStaff()->categoriesUpdated();

  return 0;
}



void KBankingSettings::backendRescan(){
  _providerListView->clear();
  _providerListView->addPluginDescrs(_banking->getProviderDescrs());
}



void KBankingSettings::backendEnable(){
  GWEN_PLUGIN_DESCRIPTION *pd;

  pd=_providerListView->getCurrentPluginDescr();
  if (!pd) {
    fprintf(stderr, "No provider selected.\n");
  }
  else {
    int rv;

    if (GWEN_PluginDescription_IsActive(pd)) {
      fprintf(stderr, "Provider already active.\n");
      return;
    }

    rv=_banking->activateProvider(GWEN_PluginDescription_GetName(pd));
    backendRescan();
    if (rv) {
      QMessageBox::critical(this,
                            tr("Backend Error"),
                            tr("Could not activate this backend.\n"),
                            tr("Dismiss"), QString::null);
    }
    else {
      _banking->accountsUpdated();
      QMessageBox::information(this,
                               tr("Backend Activated"),
                               tr("This backend has successfully been "
                                  "activated.\n"),
                               QMessageBox::Ok);
    }
  }
}



void KBankingSettings::backendDisable(){
  GWEN_PLUGIN_DESCRIPTION *pd;

  pd=_providerListView->getCurrentPluginDescr();
  if (!pd) {
    fprintf(stderr, "No provider selected.\n");
  }
  else {
    int rv;

    if (!GWEN_PluginDescription_IsActive(pd)) {
      fprintf(stderr, "Provider already inactive.\n");
      return;
    }

    int res = QMessageBox::warning(this,
                             tr("Disable Backend"),
                             tr("This would remove all accounts currently "
                                "supported by that backend.\n"
                                "\n"
                                "Do you still want me to disable it?"),
                             QMessageBox::Yes,QMessageBox::No);
    if (res !=0 && res != QMessageBox::Yes)
      return;

    rv=_banking->deactivateProvider(GWEN_PluginDescription_GetName(pd));
    backendRescan();
    if (rv) {
      QMessageBox::critical(this,
                            tr("Backend Error"),
                            tr("Could not deactivate this backend.\n"),
                            tr("Dismiss"), QString::null);
    }
  }
}



void KBankingSettings::backendSetup(){
  GWEN_PLUGIN_DESCRIPTION *pd;

  pd=_providerListView->getCurrentPluginDescr();
  if (!pd) {
    fprintf(stderr, "No provider selected.\n");
  }
  else {
    GWEN_BUFFER *pbuf;
    QString qs;
    int rv;
    GWEN_DB_NODE *dbAppData;

    dbAppData=_banking->getAppData();

    pbuf=GWEN_Buffer_new(0, 256, 0, 1);
    if (AB_Banking_FindWizard(_banking->getCInterface(),
                              GWEN_PluginDescription_GetName(pd),
                              "kde;qt;gtk;gnome",
                              pbuf)) {
      DBG_ERROR(0, "No wizard found");
      QMessageBox::critical(this,
                            tr("Wizard Not Installed"),
                            tr("<qt>"
                               "<p>"
			       "No matching wizard for this backend "
			       "installed."
			       "</p>"
                               "</qt>"),
                            tr("Dismiss"), QString::null);
      GWEN_Buffer_free(pbuf);
      return;
    }

    qs=GWEN_Buffer_GetStart(pbuf);

    rv=_banking->fini();
    assert(rv==0);

    QProcess wp(qs);

    if (!wp.launch(QString())) {
      QMessageBox::critical(this,
                            tr("Wizard Not Started"),
                            tr("<qt>"
                               "<p>"
                               "The KDE wizard for this backend could "
                               "not be started."
                               "</p>"
                               "</qt>"),
                            tr("Dismiss"), QString::null);
      rv=_banking->init();
      assert(rv==0);
      return;
    }

    DBG_ERROR(0, "Starting processwatcher here:")
    QBProcessWatcher pwatcher(&wp,
                              tr("<qt>"
                                 "<p>"
                                 "Running setup wizard, this window will close "
                                 "automatically when the wizard finishes."
                                 "</p>"
                                 "<p>"
                                 "Please wait..."
                                 "</p>"
                                 "</qt>"
                                ),
                              this,
                              "ProcessWatcher",
                              true);
    pwatcher.setCaption(caption());
    pwatcher.exec();

    if (pwatcher.getDuration()<3) {
      QMessageBox::critical(this,
                            tr("Error"),
                            tr("<qt>"
                               "<p>"
                               "Wizard terminated too fast, please check "
                               "the console logs."
                               "</p>"
                               "</qt>"),
                            tr("Dismiss"), QString::null);
    }

    rv=_banking->init();
    assert(rv==0);
    _banking->accountsUpdated();
  } // if provider selected
}
















