/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: selecttransfers.cpp 314 2005-09-07 15:38:38Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "selecttransfers.h"
#include "transferlist.h"
#include "kbanking.h"
#include <qbanking/qbplugindescrlist.h>

#include <qwidget.h>
#include <qstring.h>
#include <qlistview.h>

#include <gwenhywfar/debug.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif


SelectTransfers::SelectTransfers(KBanking *kb,
                                 const QString &title,
                                 std::list<RefPointer<Transfer> > tl,
                                 QWidget* parent,
                                 const char *name,
                                 bool modal,
                                 WFlags fl)
:SelectTransfersUi(parent, name, modal, fl)
,_app(kb)
,_transfers(tl) {

  if (!title.isEmpty())
    setCaption(title);
  transferListView->setSelectionMode(QListView::Multi);
  transferListView->setAllColumnsShowFocus(true);
}



SelectTransfers::~SelectTransfers(){
}



bool SelectTransfers::init() {
  GWEN_DB_NODE *db;
  std::string s;
  int i, j;

  db=_app->getAppData();
  if (db) {
    db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                        "gui/dialogs/selecttransfers");
    if (db) {
      int w;
      int h;
      const char *p;

      /* found settings */
      w=GWEN_DB_GetIntValue(db, "width", 0, 640);
      h=GWEN_DB_GetIntValue(db, "height", 0, 480);
      resize(w, h);

      p=GWEN_DB_GetCharValue(db, "sortOrder", 0, "ascending");
      if (p) {
        if (strcasecmp(p, "ascending")==0)
          transferListView->setSortOrder(Qt::Ascending);
        else
          if (strcasecmp(p, "descending")==0)
            transferListView->setSortOrder(Qt::Descending);
      }
      i=GWEN_DB_GetIntValue(db, "sortColumn", 0, -1);
      if (i!=-1)
        transferListView->setSortColumn(i);
      for (i=0; i<transferListView->columns(); i++) {
        transferListView->setColumnWidthMode(i, QListView::Manual);
        j=GWEN_DB_GetIntValue(db, "columns", i, -1);
        if (j!=-1)
          transferListView->setColumnWidth(i, j);
      } /* for */
    } // if transaction view setting
  } // if application settings

  transferListView->addTransfers(_transfers);
  transferListView->selectAll(true);

  return true;
}



bool SelectTransfers::fini(){
  GWEN_DB_NODE *db;
  int i, j;
  std::string s;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db,
                      GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      "gui/dialogs/selecttransfers");
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      s.c_str());
  assert(db);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "height", height());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", transferListView->sortColumn());
  switch(transferListView->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<transferListView->columns(); i++) {
    j=transferListView->columnWidth(i);
    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  return true;
}



std::list<RefPointer<Transfer> > SelectTransfers::getSelectedTransfers() {
  return transferListView->getSelectedTransfers();
}




bool
SelectTransfers::selectTransfers(KBanking *kb,
                                 std::list<RefPointer<Transfer> > tl,
                                 std::list<RefPointer<Transfer> > &selected,
                                 QWidget* parent) {
  SelectTransfers w(kb, QWidget::tr("Select Transfers"), tl, parent);
  bool res;

  if (!w.init()) {
    DBG_INFO(0, "here");
    return false;
  }

  res=(w.exec()==QDialog::Accepted);
  if (res) {
    w.transferListView->getSelectedTransfersToList(selected);
  }
  w.fini();

  return res;
}






