/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateconvertunitsdialog.h"
#include "qalculate_kde_utils.h"

#include <qlabel.h>
#include <klineedit.h>
#include <klocale.h>
#include <qhbox.h>
#include <klistview.h>
#include <klocale.h>
#include <qvbox.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qsplitter.h>

extern tree_struct unit_cats;
extern vector<void*> ia_units;
extern PrintOptions printops;
extern EvaluationOptions evalops;


QalculateConvertUnitsDialog::QalculateConvertUnitsDialog(QWidget *parent, const char *name) : KDialogBase(parent, name, false, i18n("Convert"), Ok | Apply | Cancel | Details, Ok, true) {

	setButtonText(Details, i18n("Selector"));

	selected_category = "";
	block_unit_convert = true;

	QVBox *box = makeVBoxMainWidget();
	new QLabel(i18n("Unit expression:"), box);
	unitExpressionEdit = new KLineEdit(box);
	
	QVBox *box_d = new QVBox(this);
	box_d->setSpacing(spacingHint());
	new QWidget(box_d);
	
	QSplitter *splitter = new QSplitter(Qt::Vertical, box_d);
	splitter->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
	
	setDetailsWidget(box_d);

	categoryView = new KListView(splitter);
	categoryView->addColumn(i18n("Category"));
	categoryView->setRootIsDecorated(false);
	categoryView->setFullWidth(true);

	unitView = new KListView(splitter);
	unitView->addColumn(i18n("Unit"));
	unitView->setRootIsDecorated(false);
	unitView->setFullWidth(true);

	unitExpressionEdit->setFocus();
	
	connect(unitView, SIGNAL(selectionChanged()), this, SLOT(unitSelected()));
	connect(categoryView, SIGNAL(selectionChanged()), this, SLOT(categorySelected()));

}

QalculateConvertUnitsDialog::~QalculateConvertUnitsDialog() {}

void QalculateConvertUnitsDialog::updateUnitTree() {
	unitItems.clear();
	categoryItems.clear();
	categoryView->clear();
	QListViewItem *i = new KListViewItem(categoryView, i18n("All")), *i2;
	categoryItems[i] = i18n("All");
	i->setOpen(true);
	QString str;
	tree_struct *item, *item2;
	unit_cats.it = unit_cats.items.begin();
	if(unit_cats.it != unit_cats.items.end()) {
		item = &*unit_cats.it;
		++unit_cats.it;
		item->it = item->items.begin();
	} else {
		item = NULL;
	}
	str = "";
	i2 = i;
	while(item) {
		str += "/";
		str += item->item.c_str();
		i = new KListViewItem(i2, item->item.c_str());
		i->setOpen(false);
		categoryItems[i] = str;
		if(str == selected_category) {
			categoryView->ensureItemVisible(i);
			categoryView->setSelected(i, true);
		}
		while(item && item->it == item->items.end()) {
			int str_i = str.findRev("/");
			if(str_i < 0) {
				str = "";
			} else {
				str.truncate(str_i);
			}
			item = item->parent;
			i = i->parent();
			i2 = i;
		}
		if(item) {
			item2 = &*item->it;
			if(item->it == item->items.begin())
				i2 = i;
			++item->it;
			item = item2;
			item->it = item->items.begin();
		}
	}
	if(!unit_cats.objects.empty()) {
		//add "Uncategorized" category if there are units without category
		i = new KListViewItem(categoryView, i18n("Uncategorized"));
		categoryItems[i] = i18n("Uncategorized");
		if(selected_category == i18n("Uncategorized")) {
			categoryView->ensureItemVisible(i);
			categoryView->setSelected(i, true);
		}
	}
	if(!categoryView->selectedItem()) {
		//if no category has been selected (previously selected has been renamed/deleted), select "All"
		selected_category = i18n("All");
		QListViewItemIterator it(categoryView);
		if(it.current())
			categoryView->setSelected(it.current(), true);
	}
}

void QalculateConvertUnitsDialog::unitSelected() {
	QListViewItem *selected = unitView->selectedItem();
	if(selected) {
		Unit *u = unitItems[selected];
		if(!CALCULATOR->stillHasUnit(u)) {
			KMessageBox::error(this, i18n("Unit does not exist anymore."));
			emit unitsChanged();
			return;
		}
		unitExpressionEdit->setText(u->print(false, printops.abbreviate_names, printops.use_unicode_signs, &can_display_unicode_string_function, (void*) unitExpressionEdit).c_str());
		unitView->selectAll(false);
		if(!block_unit_convert) actionButton(Apply)->animateClick();
	}
}

void QalculateConvertUnitsDialog::addUnitTreeItem(Unit *u) {
	QListViewItem *i = new KListViewItem(unitView, u->title(true).c_str());
	unitItems[i] = u;
}


void QalculateConvertUnitsDialog::categorySelected() {
	block_unit_convert = true;
	QListViewItem *selected = categoryView->selectedItem();
	bool no_cat = false, b_all = false;
	unitView->clear();
	unitItems.clear();
	if(!selected) {
		selected_category = "";
		return;
	}
	selected_category = categoryItems[selected];
	if(selected_category == i18n("All")) {
		b_all = true;
	} else if(selected_category == i18n("Uncategorized")) {
		no_cat = true;
	}
	if(!b_all && !no_cat && selected_category[0] == '/') {
		string str = selected_category.ascii();
		str.erase(str.begin());
		for(size_t i = 0; i < CALCULATOR->units.size(); i++) {
			if(CALCULATOR->units[i]->isActive() && !CALCULATOR->units[i]->isHidden() && CALCULATOR->units[i]->category().substr(0, selected_category.length() - 1) == str) {
				addUnitTreeItem(CALCULATOR->units[i]);
			}
		}
	} else {
		string str = selected_category.ascii();
		for(size_t i = 0; i < CALCULATOR->units.size(); i++) {
			if(CALCULATOR->units[i]->isActive() && !CALCULATOR->units[i]->isHidden() && (b_all || (no_cat && CALCULATOR->units[i]->category().empty()) || CALCULATOR->units[i]->category() == str)) {
				addUnitTreeItem(CALCULATOR->units[i]);
			}
		}
	}
	block_unit_convert = false;
}


#include "qalculateconvertunitsdialog.moc"
