#!/usr/bin/env python
""" bank06: Many Random Customers """
from SimPy.Simulation  import *
from random import expovariate,seed            

class Source(Process):
    """ Source generates customers randomly"""

    def generate(self,number,interval):       
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,))
            activate(c,c.visit(timeInBank=12.0)) 
            t = expovariate(1.0/interval)      
            yield hold,self,t                  

class Customer(Process):
    """ Customer arrives, looks round and leaves """
        
    def visit(self,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        yield hold,self,timeInBank
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():
    seed(99999)                             
    initialize()
    s=Source(name='Source')                  
    activate(s,s.generate(5,10.0),0.0) 
    simulate(until=400.0)

model()
