# Compilation script

import Scientific.Installation
import os, sys

# Find the Python library path
lib = os.path.join(os.path.join(sys.exec_prefix, 'lib'),
                   'python'+sys.version[:3])

# Construct the final Setup file
os.system("sed -e s+@SCIENTIFIC@+" + Scientific.Installation.include_path +
          "+g < Setup.template > Setup")

# Get a copy of Makefile.pre.in and make the Makefile
source = os.path.join(os.path.join(lib, 'config'), 'Makefile.pre.in')
if os.path.exists(source):
    os.system('cp ' + source + ' .')
os.system("make -f Makefile.pre.in boot")

# Compile the module(s).
os.system("make")
