#!/usr/bin/env python
# -*- coding: utf-8 -*-

from pytils import numeral

def print_(s):
    # pytils всегда возвращает юникод (строка в Py3.x)
    # обычно это ОК выводить юникод в терминал
    # но если это неинтерактивный вывод
    # (например, использования модуля subprocess)
    # то для Py2.x нужно использовать перекодировку в utf-8
    from pytils.third import six
    if six.PY3:
        out = s
    else:
        out = s.encode('UTF-8')
    print(out)


# choose_plural нужен для выбора правильной формы
# существительного

# у choose_plural два параметра:
# 1) amount, количество
# 2) variants, варианты
# варианты - это кортеж из вариантов склонения
# его легко составить по мнемоническому правилу:
# (один, два, пять)
# т.е. для 1, 2 и 5 объектов, например для слова "пример"
# (пример, примера, примеров)
print_(numeral.choose_plural(21, (u"пример", u"примера", u"примеров")))
#-> пример
print_(numeral.choose_plural(12, (u"пример", u"примера", u"примеров")))
#-> примеров
print_(numeral.choose_plural(32, (u"пример", u"примера", u"примеров")))
#-> примера

# также можно задавать варианты в одну строку, разделенные запятой
print_(numeral.choose_plural(32, u"пример,примера, примеров"))
#-> примера

# если в варианте используется запятая, она экранируется слешем
print_(numeral.choose_plural(35, u"гвоздь, гвоздя, гвоздей\, шпунтов"))
#-> гвоздей, шпунтов

# зачастую требуется не просто вариант, а вместе с числительным
# в этом случае следует использовать get_plural
print_(numeral.get_plural(32, u"пример,примера, примеров"))
#-> 32 примера

# часто хочется, чтобы в случае отсутсвия значения (т.е. количество равно нулю)
# выводилось не "0 примеров", а "примеров нет"
# в этом случае используйте третий параметр get_plural:
print_(numeral.get_plural(0, u"пример,примера, примеров", u"без примеров"))
# -> без примеров