/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __AVOLUME_H
#define __AVOLUME_H

// --- Project includes ---
#include "vector3.h"
#include "Sphere.h"

// --- STL includes ---
#include <utility>
#include <vector>

using std::pair;
using std::vector;

/*!
  \class AVolume

  Abstract base class for a 2D volume for particle packing
*/
class AVolume
{
 private:

 public:
  virtual ~AVolume(){};
  virtual pair<Vector3,Vector3> getBoundingBox() = 0;
  virtual Vector3 getAPoint(int) const = 0;
  //  virtual bool hasPlane() const = 0;
//  virtual bool isIn(const Vector3&) = 0;
  virtual bool isIn(const Vector3&) const = 0;
  virtual bool isIn(const Sphere&) =0;
  virtual int getNumberSubVolumes()const{return 1;};
};

#endif // __AVOLUME_H
