# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AuthenticationDetailsProperties(_serialization.Model):
    """Settings for cloud authentication management.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwAssumeRoleAuthenticationDetailsProperties, AwsCredsAuthenticationDetailsProperties,
    GcpCredentialsDetailsProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or
     ~azure.mgmt.security.v2020_01_01_preview.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationType
    """

    _validation = {
        'authentication_provisioning_state': {'readonly': True},
        'granted_permissions': {'readonly': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
    }

    _subtype_map = {
        'authentication_type': {'awsAssumeRole': 'AwAssumeRoleAuthenticationDetailsProperties', 'awsCreds': 'AwsCredsAuthenticationDetailsProperties', 'gcpCredentials': 'GcpCredentialsDetailsProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super().__init__(**kwargs)
        self.authentication_provisioning_state = None
        self.granted_permissions = None
        self.authentication_type = None  # type: Optional[str]


class AwAssumeRoleAuthenticationDetailsProperties(AuthenticationDetailsProperties):
    """AWS cloud account connector based assume role, the role enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details, refer to :code:`<a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to Delegate Permissions to an IAM User (write only)</a>`.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or
     ~azure.mgmt.security.v2020_01_01_preview.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationType
    :ivar account_id: The ID of the cloud account.
    :vartype account_id: str
    :ivar aws_assume_role_arn: Assumed role ID is an identifier that you can use to create
     temporary security credentials. Required.
    :vartype aws_assume_role_arn: str
    :ivar aws_external_id: A unique identifier that is required when you assume a role in another
     account. Required.
    :vartype aws_external_id: str
    """

    _validation = {
        'authentication_provisioning_state': {'readonly': True},
        'granted_permissions': {'readonly': True},
        'authentication_type': {'required': True},
        'account_id': {'readonly': True},
        'aws_assume_role_arn': {'required': True},
        'aws_external_id': {'required': True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "aws_assume_role_arn": {"key": "awsAssumeRoleArn", "type": "str"},
        "aws_external_id": {"key": "awsExternalId", "type": "str"},
    }

    def __init__(
        self,
        *,
        aws_assume_role_arn: str,
        aws_external_id: str,
        **kwargs
    ):
        """
        :keyword aws_assume_role_arn: Assumed role ID is an identifier that you can use to create
         temporary security credentials. Required.
        :paramtype aws_assume_role_arn: str
        :keyword aws_external_id: A unique identifier that is required when you assume a role in
         another account. Required.
        :paramtype aws_external_id: str
        """
        super().__init__(**kwargs)
        self.authentication_type = 'awsAssumeRole'  # type: str
        self.account_id = None
        self.aws_assume_role_arn = aws_assume_role_arn
        self.aws_external_id = aws_external_id


class AwsCredsAuthenticationDetailsProperties(AuthenticationDetailsProperties):
    """AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to :code:`<a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in Your AWS Account (write only)</a>`.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or
     ~azure.mgmt.security.v2020_01_01_preview.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationType
    :ivar account_id: The ID of the cloud account.
    :vartype account_id: str
    :ivar aws_access_key_id: Public key element of the AWS credential object (write only).
     Required.
    :vartype aws_access_key_id: str
    :ivar aws_secret_access_key: Secret key element of the AWS credential object (write only).
     Required.
    :vartype aws_secret_access_key: str
    """

    _validation = {
        'authentication_provisioning_state': {'readonly': True},
        'granted_permissions': {'readonly': True},
        'authentication_type': {'required': True},
        'account_id': {'readonly': True},
        'aws_access_key_id': {'required': True},
        'aws_secret_access_key': {'required': True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "aws_access_key_id": {"key": "awsAccessKeyId", "type": "str"},
        "aws_secret_access_key": {"key": "awsSecretAccessKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        aws_access_key_id: str,
        aws_secret_access_key: str,
        **kwargs
    ):
        """
        :keyword aws_access_key_id: Public key element of the AWS credential object (write only).
         Required.
        :paramtype aws_access_key_id: str
        :keyword aws_secret_access_key: Secret key element of the AWS credential object (write only).
         Required.
        :paramtype aws_secret_access_key: str
        """
        super().__init__(**kwargs)
        self.authentication_type = 'awsCreds'  # type: str
        self.account_id = None
        self.aws_access_key_id = aws_access_key_id
        self.aws_secret_access_key = aws_secret_access_key


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2020_01_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2020_01_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ConnectorSetting(Resource):
    """The connector setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar hybrid_compute_settings: Settings for hybrid compute management. These settings are
     relevant only for Arc autoProvision (Hybrid Compute).
    :vartype hybrid_compute_settings:
     ~azure.mgmt.security.v2020_01_01_preview.models.HybridComputeSettingsProperties
    :ivar authentication_details: Settings for authentication management, these settings are
     relevant only for the cloud connector.
    :vartype authentication_details:
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationDetailsProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "hybrid_compute_settings": {"key": "properties.hybridComputeSettings", "type": "HybridComputeSettingsProperties"},
        "authentication_details": {"key": "properties.authenticationDetails", "type": "AuthenticationDetailsProperties"},
    }

    def __init__(
        self,
        *,
        hybrid_compute_settings: Optional["_models.HybridComputeSettingsProperties"] = None,
        authentication_details: Optional["_models.AuthenticationDetailsProperties"] = None,
        **kwargs
    ):
        """
        :keyword hybrid_compute_settings: Settings for hybrid compute management. These settings are
         relevant only for Arc autoProvision (Hybrid Compute).
        :paramtype hybrid_compute_settings:
         ~azure.mgmt.security.v2020_01_01_preview.models.HybridComputeSettingsProperties
        :keyword authentication_details: Settings for authentication management, these settings are
         relevant only for the cloud connector.
        :paramtype authentication_details:
         ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationDetailsProperties
        """
        super().__init__(**kwargs)
        self.hybrid_compute_settings = hybrid_compute_settings
        self.authentication_details = authentication_details


class ConnectorSettingList(_serialization.Model):
    """For a subscription, list of all cloud account connectors and their settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of all the cloud account connector settings.
    :vartype value: list[~azure.mgmt.security.v2020_01_01_preview.models.ConnectorSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectorSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConnectorSetting"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of all the cloud account connector settings.
        :paramtype value: list[~azure.mgmt.security.v2020_01_01_preview.models.ConnectorSetting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class GcpCredentialsDetailsProperties(AuthenticationDetailsProperties):  # pylint: disable=too-many-instance-attributes
    """GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or
     ~azure.mgmt.security.v2020_01_01_preview.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.AuthenticationType
    :ivar organization_id: The organization ID of the GCP cloud account. Required.
    :vartype organization_id: str
    :ivar type: Type field of the API key (write only). Required.
    :vartype type: str
    :ivar project_id: Project ID field of the API key (write only). Required.
    :vartype project_id: str
    :ivar private_key_id: Private key ID field of the API key (write only). Required.
    :vartype private_key_id: str
    :ivar private_key: Private key field of the API key (write only). Required.
    :vartype private_key: str
    :ivar client_email: Client email field of the API key (write only). Required.
    :vartype client_email: str
    :ivar client_id: Client ID field of the API key (write only). Required.
    :vartype client_id: str
    :ivar auth_uri: Auth URI field of the API key (write only). Required.
    :vartype auth_uri: str
    :ivar token_uri: Token URI field of the API key (write only). Required.
    :vartype token_uri: str
    :ivar auth_provider_x509_cert_url: Auth provider x509 certificate URL field of the API key
     (write only). Required.
    :vartype auth_provider_x509_cert_url: str
    :ivar client_x509_cert_url: Client x509 certificate URL field of the API key (write only).
     Required.
    :vartype client_x509_cert_url: str
    """

    _validation = {
        'authentication_provisioning_state': {'readonly': True},
        'granted_permissions': {'readonly': True},
        'authentication_type': {'required': True},
        'organization_id': {'required': True},
        'type': {'required': True},
        'project_id': {'required': True},
        'private_key_id': {'required': True},
        'private_key': {'required': True},
        'client_email': {'required': True},
        'client_id': {'required': True},
        'auth_uri': {'required': True},
        'token_uri': {'required': True},
        'auth_provider_x509_cert_url': {'required': True},
        'client_x509_cert_url': {'required': True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "organization_id": {"key": "organizationId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "private_key_id": {"key": "privateKeyId", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "client_email": {"key": "clientEmail", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "auth_uri": {"key": "authUri", "type": "str"},
        "token_uri": {"key": "tokenUri", "type": "str"},
        "auth_provider_x509_cert_url": {"key": "authProviderX509CertUrl", "type": "str"},
        "client_x509_cert_url": {"key": "clientX509CertUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization_id: str,
        type: str,
        project_id: str,
        private_key_id: str,
        private_key: str,
        client_email: str,
        client_id: str,
        auth_uri: str,
        token_uri: str,
        auth_provider_x509_cert_url: str,
        client_x509_cert_url: str,
        **kwargs
    ):
        """
        :keyword organization_id: The organization ID of the GCP cloud account. Required.
        :paramtype organization_id: str
        :keyword type: Type field of the API key (write only). Required.
        :paramtype type: str
        :keyword project_id: Project ID field of the API key (write only). Required.
        :paramtype project_id: str
        :keyword private_key_id: Private key ID field of the API key (write only). Required.
        :paramtype private_key_id: str
        :keyword private_key: Private key field of the API key (write only). Required.
        :paramtype private_key: str
        :keyword client_email: Client email field of the API key (write only). Required.
        :paramtype client_email: str
        :keyword client_id: Client ID field of the API key (write only). Required.
        :paramtype client_id: str
        :keyword auth_uri: Auth URI field of the API key (write only). Required.
        :paramtype auth_uri: str
        :keyword token_uri: Token URI field of the API key (write only). Required.
        :paramtype token_uri: str
        :keyword auth_provider_x509_cert_url: Auth provider x509 certificate URL field of the API key
         (write only). Required.
        :paramtype auth_provider_x509_cert_url: str
        :keyword client_x509_cert_url: Client x509 certificate URL field of the API key (write only).
         Required.
        :paramtype client_x509_cert_url: str
        """
        super().__init__(**kwargs)
        self.authentication_type = 'gcpCredentials'  # type: str
        self.organization_id = organization_id
        self.type = type
        self.project_id = project_id
        self.private_key_id = private_key_id
        self.private_key = private_key
        self.client_email = client_email
        self.client_id = client_id
        self.auth_uri = auth_uri
        self.token_uri = token_uri
        self.auth_provider_x509_cert_url = auth_provider_x509_cert_url
        self.client_x509_cert_url = client_x509_cert_url


class HybridComputeSettingsProperties(_serialization.Model):
    """Settings for hybrid compute management.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar hybrid_compute_provisioning_state: State of the service principal and its secret. Known
     values are: "Valid", "Invalid", and "Expired".
    :vartype hybrid_compute_provisioning_state: str or
     ~azure.mgmt.security.v2020_01_01_preview.models.HybridComputeProvisioningState
    :ivar auto_provision: Whether or not to automatically install Azure Arc (hybrid compute) agents
     on machines. Required. Known values are: "On" and "Off".
    :vartype auto_provision: str or ~azure.mgmt.security.v2020_01_01_preview.models.AutoProvision
    :ivar resource_group_name: The name of the resource group where Arc (Hybrid Compute) connectors
     are connected.
    :vartype resource_group_name: str
    :ivar region: The location where the metadata of machines will be stored.
    :vartype region: str
    :ivar proxy_server: For a non-Azure machine that is not connected directly to the internet,
     specify a proxy server that the non-Azure machine can use.
    :vartype proxy_server: ~azure.mgmt.security.v2020_01_01_preview.models.ProxyServerProperties
    :ivar service_principal: An object to access resources that are secured by an Azure AD tenant.
    :vartype service_principal:
     ~azure.mgmt.security.v2020_01_01_preview.models.ServicePrincipalProperties
    """

    _validation = {
        'hybrid_compute_provisioning_state': {'readonly': True},
        'auto_provision': {'required': True},
    }

    _attribute_map = {
        "hybrid_compute_provisioning_state": {"key": "hybridComputeProvisioningState", "type": "str"},
        "auto_provision": {"key": "autoProvision", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "proxy_server": {"key": "proxyServer", "type": "ProxyServerProperties"},
        "service_principal": {"key": "servicePrincipal", "type": "ServicePrincipalProperties"},
    }

    def __init__(
        self,
        *,
        auto_provision: Union[str, "_models.AutoProvision"],
        resource_group_name: Optional[str] = None,
        region: Optional[str] = None,
        proxy_server: Optional["_models.ProxyServerProperties"] = None,
        service_principal: Optional["_models.ServicePrincipalProperties"] = None,
        **kwargs
    ):
        """
        :keyword auto_provision: Whether or not to automatically install Azure Arc (hybrid compute)
         agents on machines. Required. Known values are: "On" and "Off".
        :paramtype auto_provision: str or ~azure.mgmt.security.v2020_01_01_preview.models.AutoProvision
        :keyword resource_group_name: The name of the resource group where Arc (Hybrid Compute)
         connectors are connected.
        :paramtype resource_group_name: str
        :keyword region: The location where the metadata of machines will be stored.
        :paramtype region: str
        :keyword proxy_server: For a non-Azure machine that is not connected directly to the internet,
         specify a proxy server that the non-Azure machine can use.
        :paramtype proxy_server: ~azure.mgmt.security.v2020_01_01_preview.models.ProxyServerProperties
        :keyword service_principal: An object to access resources that are secured by an Azure AD
         tenant.
        :paramtype service_principal:
         ~azure.mgmt.security.v2020_01_01_preview.models.ServicePrincipalProperties
        """
        super().__init__(**kwargs)
        self.hybrid_compute_provisioning_state = None
        self.auto_provision = auto_provision
        self.resource_group_name = resource_group_name
        self.region = region
        self.proxy_server = proxy_server
        self.service_principal = service_principal


class ProxyServerProperties(_serialization.Model):
    """For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.

    :ivar ip: Proxy server IP.
    :vartype ip: str
    :ivar port: Proxy server port.
    :vartype port: str
    """

    _attribute_map = {
        "ip": {"key": "ip", "type": "str"},
        "port": {"key": "port", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip: Optional[str] = None,
        port: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ip: Proxy server IP.
        :paramtype ip: str
        :keyword port: Proxy server port.
        :paramtype port: str
        """
        super().__init__(**kwargs)
        self.ip = ip
        self.port = port


class ServicePrincipalProperties(_serialization.Model):
    """Details of the service principal.

    :ivar application_id: Application ID of service principal.
    :vartype application_id: str
    :ivar secret: A secret string that the application uses to prove its identity, also can be
     referred to as application password (write only).
    :vartype secret: str
    """

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(
        self,
        *,
        application_id: Optional[str] = None,
        secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword application_id: Application ID of service principal.
        :paramtype application_id: str
        :keyword secret: A secret string that the application uses to prove its identity, also can be
         referred to as application password (write only).
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.application_id = application_id
        self.secret = secret
