# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import PolicyInsightsClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AttestationsOperations,
    Operations,
    PolicyEventsOperations,
    PolicyMetadataOperations,
    PolicyRestrictionsOperations,
    PolicyStatesOperations,
    PolicyTrackedResourcesOperations,
    RemediationsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class PolicyInsightsClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """PolicyInsightsClient.

    :ivar policy_tracked_resources: PolicyTrackedResourcesOperations operations
    :vartype policy_tracked_resources:
     azure.mgmt.policyinsights.operations.PolicyTrackedResourcesOperations
    :ivar remediations: RemediationsOperations operations
    :vartype remediations: azure.mgmt.policyinsights.operations.RemediationsOperations
    :ivar policy_events: PolicyEventsOperations operations
    :vartype policy_events: azure.mgmt.policyinsights.operations.PolicyEventsOperations
    :ivar policy_states: PolicyStatesOperations operations
    :vartype policy_states: azure.mgmt.policyinsights.operations.PolicyStatesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.policyinsights.operations.Operations
    :ivar policy_metadata: PolicyMetadataOperations operations
    :vartype policy_metadata: azure.mgmt.policyinsights.operations.PolicyMetadataOperations
    :ivar policy_restrictions: PolicyRestrictionsOperations operations
    :vartype policy_restrictions: azure.mgmt.policyinsights.operations.PolicyRestrictionsOperations
    :ivar attestations: AttestationsOperations operations
    :vartype attestations: azure.mgmt.policyinsights.operations.AttestationsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Microsoft Azure subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = PolicyInsightsClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.policy_tracked_resources = PolicyTrackedResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.remediations = RemediationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_events = PolicyEventsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_states = PolicyStatesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_metadata = PolicyMetadataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_restrictions = PolicyRestrictionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.attestations = AttestationsOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> PolicyInsightsClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
