# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Address(msrest.serialization.Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to Azure.

    :ivar address1: Required. First line of an Address.
    :vartype address1: str
    :ivar address2: The second line of the Address. Optional.
    :vartype address2: str
    :ivar city: Required. The city for the address.
    :vartype city: str
    :ivar country: Required. The country for the address.
    :vartype country: str
    :ivar postal_code: Required. The postal code for the address.
    :vartype postal_code: str
    :ivar state: Required. The state or province for the address.
    :vartype state: str
    """

    _validation = {
        'address1': {'required': True},
        'city': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'address1': {'key': 'address1', 'type': 'str'},
        'address2': {'key': 'address2', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address1: str,
        city: str,
        country: str,
        postal_code: str,
        state: str,
        address2: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address1: Required. First line of an Address.
        :paramtype address1: str
        :keyword address2: The second line of the Address. Optional.
        :paramtype address2: str
        :keyword city: Required. The city for the address.
        :paramtype city: str
        :keyword country: Required. The country for the address.
        :paramtype country: str
        :keyword postal_code: Required. The postal code for the address.
        :paramtype postal_code: str
        :keyword state: Required. The state or province for the address.
        :paramtype state: str
        """
        super(Address, self).__init__(**kwargs)
        self.address1 = address1
        self.address2 = address2
        self.city = city
        self.country = country
        self.postal_code = postal_code
        self.state = state


class Contact(msrest.serialization.Model):
    """Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is made publicly available through the Whois 
directories as per ICANN requirements.

    All required parameters must be populated in order to send to Azure.

    :ivar address_mailing: Mailing address.
    :vartype address_mailing: ~azure.mgmt.web.v2015_04_01.models.Address
    :ivar email: Required. Email address.
    :vartype email: str
    :ivar fax: Fax number.
    :vartype fax: str
    :ivar job_title: Job title.
    :vartype job_title: str
    :ivar name_first: Required. First name.
    :vartype name_first: str
    :ivar name_last: Required. Last name.
    :vartype name_last: str
    :ivar name_middle: Middle name.
    :vartype name_middle: str
    :ivar organization: Organization contact belongs to.
    :vartype organization: str
    :ivar phone: Required. Phone number.
    :vartype phone: str
    """

    _validation = {
        'email': {'required': True},
        'name_first': {'required': True},
        'name_last': {'required': True},
        'phone': {'required': True},
    }

    _attribute_map = {
        'address_mailing': {'key': 'addressMailing', 'type': 'Address'},
        'email': {'key': 'email', 'type': 'str'},
        'fax': {'key': 'fax', 'type': 'str'},
        'job_title': {'key': 'jobTitle', 'type': 'str'},
        'name_first': {'key': 'nameFirst', 'type': 'str'},
        'name_last': {'key': 'nameLast', 'type': 'str'},
        'name_middle': {'key': 'nameMiddle', 'type': 'str'},
        'organization': {'key': 'organization', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: str,
        name_first: str,
        name_last: str,
        phone: str,
        address_mailing: Optional["_models.Address"] = None,
        fax: Optional[str] = None,
        job_title: Optional[str] = None,
        name_middle: Optional[str] = None,
        organization: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address_mailing: Mailing address.
        :paramtype address_mailing: ~azure.mgmt.web.v2015_04_01.models.Address
        :keyword email: Required. Email address.
        :paramtype email: str
        :keyword fax: Fax number.
        :paramtype fax: str
        :keyword job_title: Job title.
        :paramtype job_title: str
        :keyword name_first: Required. First name.
        :paramtype name_first: str
        :keyword name_last: Required. Last name.
        :paramtype name_last: str
        :keyword name_middle: Middle name.
        :paramtype name_middle: str
        :keyword organization: Organization contact belongs to.
        :paramtype organization: str
        :keyword phone: Required. Phone number.
        :paramtype phone: str
        """
        super(Contact, self).__init__(**kwargs)
        self.address_mailing = address_mailing
        self.email = email
        self.fax = fax
        self.job_title = job_title
        self.name_first = name_first
        self.name_last = name_last
        self.name_middle = name_middle
        self.organization = organization
        self.phone = phone


class CsmOperationCollection(msrest.serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2015_04_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmOperationDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.CsmOperationDescription"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2015_04_01.models.CsmOperationDescription]
        """
        super(CsmOperationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(msrest.serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.web.v2015_04_01.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties: ~azure.mgmt.web.v2015_04_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'CsmOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CsmOperationDescriptionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.CsmOperationDescriptionProperties"] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.web.v2015_04_01.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties: ~azure.mgmt.web.v2015_04_01.models.CsmOperationDescriptionProperties
        """
        super(CsmOperationDescription, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(msrest.serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.web.v2015_04_01.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification: ~azure.mgmt.web.v2015_04_01.models.ServiceSpecification
        """
        super(CsmOperationDescriptionProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(msrest.serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super(CsmOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Dimension(msrest.serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, 
where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class Domain(Resource):
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar registration_status: Domain registration status. Known values are: "Active", "Awaiting",
     "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held", "Locked",
     "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown", "Unlocked",
     "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2015_04_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_04_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2015_04_01.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2015_04_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2015_04_01.models.DomainPropertiesDomainNotRenewableReasonsItem]
    :ivar dns_type: Current DNS type. Known values are: "AzureDns", "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Known values are:
     "AzureDns", "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        contact_admin: Optional["_models.Contact"] = None,
        contact_billing: Optional["_models.Contact"] = None,
        contact_registrant: Optional["_models.Contact"] = None,
        contact_tech: Optional["_models.Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: Optional[bool] = True,
        consent: Optional["_models.DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2015_04_01.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Known values are: "AzureDns", "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Known values are:
         "AzureDns", "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super(Domain, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainAvailablilityCheckResult(msrest.serialization.Model):
    """Domain availability check result.

    :ivar name: Name of the domain.
    :vartype name: str
    :ivar available: :code:`<code>true</code>` if domain can be purchased using CreateDomain API;
     otherwise, :code:`<code>false</code>`.
    :vartype available: bool
    :ivar domain_type: Valid values are Regular domain: Azure will charge the full price of domain
     registration, SoftDeleted: Purchasing this domain will simply restore it and this operation
     will not cost anything. Known values are: "Regular", "SoftDeleted".
    :vartype domain_type: str or ~azure.mgmt.web.v2015_04_01.models.DomainType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'domain_type': {'key': 'domainType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available: Optional[bool] = None,
        domain_type: Optional[Union[str, "_models.DomainType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the domain.
        :paramtype name: str
        :keyword available: :code:`<code>true</code>` if domain can be purchased using CreateDomain
         API; otherwise, :code:`<code>false</code>`.
        :paramtype available: bool
        :keyword domain_type: Valid values are Regular domain: Azure will charge the full price of
         domain registration, SoftDeleted: Purchasing this domain will simply restore it and this
         operation will not cost anything. Known values are: "Regular", "SoftDeleted".
        :paramtype domain_type: str or ~azure.mgmt.web.v2015_04_01.models.DomainType
        """
        super(DomainAvailablilityCheckResult, self).__init__(**kwargs)
        self.name = name
        self.available = available
        self.domain_type = domain_type


class DomainCollection(msrest.serialization.Model):
    """Collection of domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2015_04_01.models.Domain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.Domain"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2015_04_01.models.Domain]
        """
        super(DomainCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainControlCenterSsoRequest(msrest.serialization.Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        'url': {'readonly': True},
        'post_parameter_key': {'readonly': True},
        'post_parameter_value': {'readonly': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'post_parameter_key': {'key': 'postParameterKey', 'type': 'str'},
        'post_parameter_value': {'key': 'postParameterValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DomainControlCenterSsoRequest, self).__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class DomainOwnershipIdentifier(ProxyOnlyResource):
    """Domain ownership Identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar ownership_id: Ownership Id.
    :vartype ownership_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ownership_id': {'key': 'properties.ownershipId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        ownership_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword ownership_id: Ownership Id.
        :paramtype ownership_id: str
        """
        super(DomainOwnershipIdentifier, self).__init__(kind=kind, **kwargs)
        self.ownership_id = ownership_id


class DomainOwnershipIdentifierCollection(msrest.serialization.Model):
    """Collection of domain ownership identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2015_04_01.models.DomainOwnershipIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainOwnershipIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.DomainOwnershipIdentifier"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2015_04_01.models.DomainOwnershipIdentifier]
        """
        super(DomainOwnershipIdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainPatchResource(ProxyOnlyResource):
    """ARM resource for a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2015_04_01.models.Contact
    :ivar registration_status: Domain registration status. Known values are: "Active", "Awaiting",
     "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held", "Locked",
     "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown", "Unlocked",
     "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2015_04_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_04_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2015_04_01.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2015_04_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2015_04_01.models.DomainPatchResourcePropertiesDomainNotRenewableReasonsItem]
    :ivar dns_type: Current DNS type. Known values are: "AzureDns", "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Known values are:
     "AzureDns", "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        contact_admin: Optional["_models.Contact"] = None,
        contact_billing: Optional["_models.Contact"] = None,
        contact_registrant: Optional["_models.Contact"] = None,
        contact_tech: Optional["_models.Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: Optional[bool] = True,
        consent: Optional["_models.DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2015_04_01.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2015_04_01.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Known values are: "AzureDns", "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Known values are:
         "AzureDns", "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2015_04_01.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super(DomainPatchResource, self).__init__(kind=kind, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainPurchaseConsent(msrest.serialization.Model):
    """Domain purchase consent object, representing acceptance of applicable legal agreements.

    :ivar agreement_keys: List of applicable legal agreement keys. This list can be retrieved using
     ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
    :vartype agreement_keys: list[str]
    :ivar agreed_by: Client IP address.
    :vartype agreed_by: str
    :ivar agreed_at: Timestamp when the agreements were accepted.
    :vartype agreed_at: ~datetime.datetime
    """

    _attribute_map = {
        'agreement_keys': {'key': 'agreementKeys', 'type': '[str]'},
        'agreed_by': {'key': 'agreedBy', 'type': 'str'},
        'agreed_at': {'key': 'agreedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        agreement_keys: Optional[List[str]] = None,
        agreed_by: Optional[str] = None,
        agreed_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword agreement_keys: List of applicable legal agreement keys. This list can be retrieved
         using ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
        :paramtype agreement_keys: list[str]
        :keyword agreed_by: Client IP address.
        :paramtype agreed_by: str
        :keyword agreed_at: Timestamp when the agreements were accepted.
        :paramtype agreed_at: ~datetime.datetime
        """
        super(DomainPurchaseConsent, self).__init__(**kwargs)
        self.agreement_keys = agreement_keys
        self.agreed_by = agreed_by
        self.agreed_at = agreed_at


class DomainRecommendationSearchParameters(msrest.serialization.Model):
    """Domain recommendation search parameters.

    :ivar keywords: Keywords to be used for generating domain recommendations.
    :vartype keywords: str
    :ivar max_domain_recommendations: Maximum number of recommendations.
    :vartype max_domain_recommendations: int
    """

    _attribute_map = {
        'keywords': {'key': 'keywords', 'type': 'str'},
        'max_domain_recommendations': {'key': 'maxDomainRecommendations', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        keywords: Optional[str] = None,
        max_domain_recommendations: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword keywords: Keywords to be used for generating domain recommendations.
        :paramtype keywords: str
        :keyword max_domain_recommendations: Maximum number of recommendations.
        :paramtype max_domain_recommendations: int
        """
        super(DomainRecommendationSearchParameters, self).__init__(**kwargs)
        self.keywords = keywords
        self.max_domain_recommendations = max_domain_recommendations


class ErrorResponse(msrest.serialization.Model):
    """Error Response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class HostName(msrest.serialization.Model):
    """Details of a hostname derived from a domain.

    :ivar name: Name of the hostname.
    :vartype name: str
    :ivar site_names: List of apps the hostname is assigned to. This list will have more than one
     app only if the hostname is pointing to a Traffic Manager.
    :vartype site_names: list[str]
    :ivar azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
     assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
     app name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Type of the Azure resource the hostname is assigned to. Known values
     are: "Website", "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2015_04_01.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Type of the DNS record. Known values are: "CName", "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2015_04_01.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Type of the hostname. Known values are: "Verified", "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2015_04_01.models.HostNameType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'site_names': {'key': 'siteNames', 'type': '[str]'},
        'azure_resource_name': {'key': 'azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'hostNameType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        site_names: Optional[List[str]] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the hostname.
        :paramtype name: str
        :keyword site_names: List of apps the hostname is assigned to. This list will have more than
         one app only if the hostname is pointing to a Traffic Manager.
        :paramtype site_names: list[str]
        :keyword azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
         assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
         app name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Type of the Azure resource the hostname is assigned to. Known
         values are: "Website", "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2015_04_01.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Type of the DNS record. Known values are: "CName",
         "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2015_04_01.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Type of the hostname. Known values are: "Verified", "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2015_04_01.models.HostNameType
        """
        super(HostName, self).__init__(**kwargs)
        self.name = name
        self.site_names = site_names
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type


class MetricAvailability(msrest.serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(msrest.serialization.Model):
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.web.v2015_04_01.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.web.v2015_04_01.models.MetricAvailability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["_models.MetricAvailability"]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.web.v2015_04_01.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.web.v2015_04_01.models.MetricAvailability]
        """
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities


class NameIdentifier(msrest.serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super(NameIdentifier, self).__init__(**kwargs)
        self.name = name


class NameIdentifierCollection(msrest.serialization.Model):
    """Collection of domain name identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2015_04_01.models.NameIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NameIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.NameIdentifier"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2015_04_01.models.NameIdentifier]
        """
        super(NameIdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceSpecification(msrest.serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications: list[~azure.mgmt.web.v2015_04_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications:
        :paramtype metric_specifications: list[~azure.mgmt.web.v2015_04_01.models.MetricSpecification]
        """
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class TldLegalAgreement(msrest.serialization.Model):
    """Legal agreement for a top level domain.

    All required parameters must be populated in order to send to Azure.

    :ivar agreement_key: Required. Unique identifier for the agreement.
    :vartype agreement_key: str
    :ivar title: Required. Agreement title.
    :vartype title: str
    :ivar content: Required. Agreement details.
    :vartype content: str
    :ivar url: URL where a copy of the agreement details is hosted.
    :vartype url: str
    """

    _validation = {
        'agreement_key': {'required': True},
        'title': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'agreement_key': {'key': 'agreementKey', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agreement_key: str,
        title: str,
        content: str,
        url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword agreement_key: Required. Unique identifier for the agreement.
        :paramtype agreement_key: str
        :keyword title: Required. Agreement title.
        :paramtype title: str
        :keyword content: Required. Agreement details.
        :paramtype content: str
        :keyword url: URL where a copy of the agreement details is hosted.
        :paramtype url: str
        """
        super(TldLegalAgreement, self).__init__(**kwargs)
        self.agreement_key = agreement_key
        self.title = title
        self.content = content
        self.url = url


class TldLegalAgreementCollection(msrest.serialization.Model):
    """Collection of top-level domain legal agreements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2015_04_01.models.TldLegalAgreement]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TldLegalAgreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.TldLegalAgreement"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2015_04_01.models.TldLegalAgreement]
        """
        super(TldLegalAgreementCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TopLevelDomain(ProxyOnlyResource):
    """A top level domain object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar domain_name: Name of the top level domain.
    :vartype domain_name: str
    :ivar privacy: If :code:`<code>true</code>`, then the top level domain supports domain privacy;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'properties.name', 'type': 'str'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        privacy: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword privacy: If :code:`<code>true</code>`, then the top level domain supports domain
         privacy; otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        """
        super(TopLevelDomain, self).__init__(kind=kind, **kwargs)
        self.domain_name = None
        self.privacy = privacy


class TopLevelDomainAgreementOption(msrest.serialization.Model):
    """Options for retrieving the list of top level domain legal agreements.

    :ivar include_privacy: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
    :vartype include_privacy: bool
    :ivar for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
    :vartype for_transfer: bool
    """

    _attribute_map = {
        'include_privacy': {'key': 'includePrivacy', 'type': 'bool'},
        'for_transfer': {'key': 'forTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        include_privacy: Optional[bool] = None,
        for_transfer: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword include_privacy: If :code:`<code>true</code>`, then the list of agreements will
         include agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
        :paramtype include_privacy: bool
        :keyword for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
         agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
        :paramtype for_transfer: bool
        """
        super(TopLevelDomainAgreementOption, self).__init__(**kwargs)
        self.include_privacy = include_privacy
        self.for_transfer = for_transfer


class TopLevelDomainCollection(msrest.serialization.Model):
    """Collection of Top-level domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2015_04_01.models.TopLevelDomain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopLevelDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.TopLevelDomain"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2015_04_01.models.TopLevelDomain]
        """
        super(TopLevelDomainCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None
