# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VolumeResourceDescription(Model):
    """Describes a service fabric volume resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: User readable description of the volume.
    :type description: str
    :ivar provider: Required. Provider of the volume. Default value:
     "SFAzureFile" .
    :vartype provider: str
    :param azure_file_parameters: This type describes a volume provided by an
     Azure Files file share.
    :type azure_file_parameters:
     ~azure.servicefabric.models.VolumeProviderParametersAzureFile
    :param name: Required. Volume resource name.
    :type name: str
    """

    _validation = {
        'provider': {'required': True, 'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'azure_file_parameters': {'key': 'properties.azureFileParameters', 'type': 'VolumeProviderParametersAzureFile'},
        'name': {'key': 'name', 'type': 'str'},
    }

    provider = "SFAzureFile"

    def __init__(self, *, name: str, description: str=None, azure_file_parameters=None, **kwargs) -> None:
        super(VolumeResourceDescription, self).__init__(**kwargs)
        self.description = description
        self.azure_file_parameters = azure_file_parameters
        self.name = name
