# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class ManagedInstanceEncryptionProtector(ProxyResource):
    """The managed instance encryption protector.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :param server_key_name: The name of the managed instance key.
    :type server_key_name: str
    :param server_key_type: Required. The encryption protector type like
     'ServiceManaged', 'AzureKeyVault'. Possible values include:
     'ServiceManaged', 'AzureKeyVault'
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'server_key_type': {'required': True},
        'uri': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_name': {'key': 'properties.serverKeyName', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceEncryptionProtector, self).__init__(**kwargs)
        self.kind = None
        self.server_key_name = kwargs.get('server_key_name', None)
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = None
        self.thumbprint = None
