__revision__ = '$Id: __init__.py,v 1.3 2003/11/21 01:55:46 mbrown Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)

    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    #RIL parser tests; RIL parser is no longer installed
    ignored_files = ['test_parser',
                     'test_parsed_action',
                     'test_parsed_assert',
                     'test_parsed_command',
                     'test_parsed_query',
                     'test_parsed_rule',
                     ]
    RemoveTests(files, ignored_files)

    ordered_files = ['test_action',
                     'test_assert',
                     'test_command',
                     'test_predicate',
                     'test_query',
                     'test_rule',
                     'test_inferenceengine_core',
                     ]
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)
