import sys, os
from distutils.command import bdist

import Util

class BDist(bdist.bdist):

    command_name = 'bdist'
    
    format_command = bdist.bdist.format_command.copy()
    format_command['inno'] = ('bdist_inno', 'Windows InnoSetup installer')

    def finalize_options(self):
        if self.formats is None:
            # Choose the default format for this platform
            if sys.platform == 'linux2':
                self.formats = ['rpm']
            elif sys.platform == 'win32':
                self.formats = ['inno']

        # 'bdist_base' -- parent of per-built-distribution-format
        # temporary directories (eg. we'll probably have
        # "build/bdist.<plat>/dumb", "build/bdist.<plat>/rpm", etc.)
        if self.bdist_base is None:
            build_base = self.get_finalized_command('build').build_base
            plat_build = 'bdist.' + Util.GetPlatformSpecifier()
            self.bdist_base = os.path.join(build_base, plat_build)

        bdist.bdist.finalize_options(self)
        return
