########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Remove/Member.py,v 1.8 2004/09/23 20:53:31 mbrown Exp $
"""
Implementation of '4ss remove member' command

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command removes a User from a Group in a 4Suite \
repository. If necessary, you will be prompted first for credentials \
and access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import ResourceTypes


def Run(options,args):
    repo = CommandUtil.GetRepository(options,'4ss.remove.member')
    if repo is not None:
        commit = False
        username = args['userName']
        groupname = args['groupName']
        try:
            user = repo.fetchUserOrGroupByName(username)
            group = repo.fetchUserOrGroupByName(groupname)
            if user is not None:
                if group is not None:
                    if user.isResourceType(ResourceTypes.ResourceType.USER):
                        if group.isResourceType(ResourceTypes.ResourceType.GROUP):
                            group.removeMember(user)
                            commit = True
                        else:
                            sys.stderr.write("%s is a user, not a group.\n" % groupname)
                            sys.stderr.flush()
                    else:
                        sys.stderr.write("%s is a group, not a user.\n" % username)
                        sys.stderr.flush()
                else:
                    sys.stderr.write("Group %s does not exist.\n" % groupname)
                    sys.stderr.flush()
            else:
                sys.stderr.write("User %s does not exist.\n" % username)
                sys.stderr.flush()
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass
    return

def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('member',
                          """Remove a User from a Group in a repository""",
                          'developers michael',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('groupName',
                                                                  "The name (not path) of the Group",
                                                                  str),
                                       Arguments.RequiredArgument('userName',
                                                                  "The name (not path) of the User",
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
