########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Create/Group.py,v 1.8 2004/09/23 20:53:28 mbrown Exp $
"""
Implementation of '4ss create group' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command creates a new Group resource in a 4Suite \
repository. If necessary, you will be prompted first for credentials \
and access info to connect to the repository."""


from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import ResourceTypes, AclConstants

def Run(options,args):
    repo = CommandUtil.GetRepository(options,'4ss.create.group')
    if repo is not None:
        commit = False
        if options.has_key('container'):
            containerPath = options['container']
        else:
            containerPath = '/ftss/groups'
        try:
            container = repo.fetchResource(containerPath)
            if container.isResourceType(ResourceTypes.ResourceType.CONTAINER):
                group = container.createGroup(args['groupName'])
                #group.setOwner(group)
                group.setAcl(AclConstants.READ_ACCESS,
                            AclConstants.WORLD_GROUP_NAME,
                            AclConstants.ALLOWED)
                commit = 1
            else:
                sys.stderr.write("The resource '%s' is not a container.\n" % container.getPath())
                sys.stderr.flush()
        finally:
            if commit:
                repo.txCommit()
            else:
                repo.txRollback()
    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    # just for help message
    defaultContainer = '/ftss/groups'

    cmd = Command.Command('group',
                          'Create a new Group in a repository',
                          'developers',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('groupName',
                                                                  'The name of the group to create',
                                                                  str),
                                       ],
                          options = Options.Options([Options.Option('c',
                                                                    'container=PATH',
                                                                    'The container in which to create the group (default: \'%s\')' % defaultContainer),
                                                    ]),
                          fileName = __file__,
                          )
    return cmd

