########################################################################
#
# File Name: 	        Type.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Type.py.html
#
"""
Implements the Type meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import MetaObject
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.PersistentObject import TupleDefinitions
td = TupleDefinitions


from Ft.Ods.Exception import FtodsUnknownError

class Type(MetaObject.MetaObject):

    def __init__(self, db, data,meta_kind):
        MetaObject.MetaObject.__init__(self,db,data,meta_kind)

    def add_collections(self,target,inverse=1):
        from Ft.Ods.MetaData import Collection
        self._4ods_addRelationship('collections',Collection.Collection,'subtype','form',target,inverse)
    form_collections = add_collections


    def remove_collections(self,target,inverse=1):
        self._4ods_removeRelationship('collections','subtype','drop',target,inverse)
    drop_collections = remove_collections


    def add_dictionaries(self,target,inverse=1):
        from Ft.Ods.MetaData import Dictionary
        self._4ods_addRelationship('dictionaries',Dictionary.Dictionary,'key_type','form',target,inverse)
    form_dictionaries = add_dictionaries


    def remove_dictionaries(self,target,inverse=1):
        self._4ods_removeRelationship('dictionaries','key_type','drop',target,inverse)
    drop_dictionaries = remove_dictionaries


    def add_specifiers(self,target,inverse=1):
        from Ft.Ods.MetaData import Specifier
        self._4ods_addRelationship('specifiers',Specifier.Specifier,'type','form',target,inverse)
    form_specifiers=add_specifiers


    def remove_specifiers(self,target,inverse=1):
        self._4ods_removeRelationship('specifiers','type','drop',target,inverse)
    drop_specifiers = remove_specifiers


    def add_unions(self,target,inverse=1):
        from Ft.Ods.MetaData import Union
        self._4ods_addRelationship('unions',Union.Union,'switch_type','form',target,inverse)
    form_unions=add_unions


    def remove_unions(self,target,inverse=1):
        self._4ods_removeRelationship('unions','switch_type','drop',target,inverse)
    drop_unions=remove_unions


    def add_operations(self,target,inverse=1):
        from Ft.Ods.MetaData import Operation
        self._4ods_addRelationship('operations',Operation.Operation,'result','form',target,inverse)
    form_operations = add_operations


    def remove_operations(self,target,inverse=1):
        self._4ods_removeRelationship('operations','result','drop',target,inverse)
    drop_operations = remove_operations


    def add_properties(self,target,inverse=1):
        from Ft.Ods.MetaData import Property
        self._4ods_addRelationship('properties',Property.Property,'type','form',target,inverse)
    form_properties=add_properties


    def remove_properties(self,target,inverse=1):
        self._4ods_removeRelationship('properties','type','drop',target,inverse)
    drop_properties=remove_properties


    def add_constants(self,target,inverse=1):
        from Ft.Ods.MetaData import Constant
        self._4ods_addRelationship('constants',Constant.Constant,'type','form',target,inverse)
    form_constants = add_constants


    def remove_constants(self,target,inverse=1):
        self._4ods_removeRelationship('constants','type','drop',target,inverse)
    drop_constants = remove_constants


    def add_type_defs(self,target,inverse=1):
        from Ft.Ods.MetaData import TypeDefinition
        self._4ods_addRelationship('type_defs',TypeDefinition.TypeDefinition,'alias','form',target,inverse)
    form_type_defs=add_type_defs


    def remove_type_defs(self,target,inverse=1):
        self._4ods_removeRelationship('type_defs','alias','drop',target,inverse)
    drop_type_defs = remove_type_defs


    def _4ods_getOdmgType(self):
        raise FtodsUnknownError(msg='Subclass %s must override' % self.__class__.__name__)


    _tupleNames = (('collections',),('dictionaries',),('specifiers',),('unions',),('operations',),('properties',),('constants',),('type_defs',))

    _tupleDefinitions = {'collections':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        td.RELATIONSHIP:1,
                                        td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                        },
                         'dictionaries':{td.TYPE:Constants.Types.SET_COLLECTION,
                                         td.READONLY:1,
                                         td.RELATIONSHIP:1,
                                         td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                         },
                         'specifiers':{td.TYPE:Constants.Types.SET_COLLECTION,
                                       td.READONLY:1,
                                       td.RELATIONSHIP:1,
                                       td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                       },
                         'unions':{td.TYPE:Constants.Types.SET_COLLECTION,
                                   td.READONLY:1,
                                   td.RELATIONSHIP:1,
                                   td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                   },
                         'operations':{td.TYPE:Constants.Types.SET_COLLECTION,
                                       td.READONLY:1,
                                       td.RELATIONSHIP:1,
                                       td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                       },
                         'properties':{td.TYPE:Constants.Types.SET_COLLECTION,
                                       td.READONLY:1,
                                       td.RELATIONSHIP:1,
                                       td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                       },
                         'constants':{td.TYPE:Constants.Types.SET_COLLECTION,
                                      td.READONLY:1,
                                      td.RELATIONSHIP:1,
                                      td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                      },
                         'type_defs':{td.TYPE:Constants.Types.SET_COLLECTION,
                                      td.READONLY:1,
                                      td.RELATIONSHIP:1,
                                      td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                      },
                         }

    _localExtents = ('ftods_types',)



