import os, sys, cStringIO
import test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import OifAdapter


odl_string = """

module Test {

class Person (extent people)
{
	attribute string name;
        attribute string ssn;
        relationship list<Person> influenced_from inverse Person :: influences;
        relationship list<Person> influences inverse Person :: influenced_from;
};

class Professor;

class Student extends Person
{
	relationship Professor learns_from inverse Professor :: teaches;
};

class Professor extends Person
{
	relationship list<Student> teaches inverse Student :: learns_from;
};

};
"""
#"
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')


def _Test(tester):

    tester.startGroup('OIF Test %s Driver' % tester.test_data['driver'])

    tester.startTest("OIF")
    tester.warning("OIF Broken")
    tester.testDone()
    tester.groupDone()
    return
                    

    test_util.DbInit(DBNAME, odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Person
        from Test import Professor
        from Test import Student
    except:
        tester.error('Error in syntax', 1)
    reload(Person)
    reload(Professor)
    reload(Student)

    tester.testDone()

    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()


    tester.startTest('Create the classes')

    p = Professor.new(db)
    s = Student.new(db)

    sInfluenced = Student.new(db)

    p.name = "Prof"
    s.name = "Stud"
    sInfluenced.name = "Inf"

    s.learns_from = p
    p.add_influences(sInfluenced)

    tx.commit()
    tester.testDone()
    

    pId = p._4ods_getId()
    sId = s._4ods_getId()
    iId = sInfluenced._4ods_getId()



    tester.startTest("Test the relationships")
    tx = db.new()
    tx.begin()

    p = db._4ods_getPersistentObjectById(Constants.ObjectTypes.OBJECT,pId)
    s = db._4ods_getPersistentObjectById(Constants.ObjectTypes.OBJECT,sId)
    i = db._4ods_getPersistentObjectById(Constants.ObjectTypes.OBJECT,iId)


    tester.testResults(p,s.learns_from,done=0,msg="Invalid Learns from")
    tester.testResults(s,p.teaches[0],done=0,msg="Invalid teaches")
    tester.testResults(i,p.influences[0],done=0,msg="Invalid influences")
    tester.testResults(p,i.influenced_from[0],done=0,msg="Invalid influenced_from")

    tester.testDone()

    tx.abort()
    db.close()

    oif = OifAdapter.OifAdapter(DBNAME)
    oif.begin()
    stream = cStringIO.StringIO()
    oif.odmsdump(stream)
    oif.abort()

    test_util.DbInit(DBNAME, odl_string)
    tester.startTest("OIF odmsdump/odmsload")
    oif.begin()
    print 'Loading...'
    print stream.getvalue()
    stream.seek(0)
    oif.odmsload(stream)
    oif.commit()
    oif.begin()
    print 'Dumping...'
    oif.odmsdump(sys.stdout)
    oif.abort()
    tester.testDone()
    
    tester.groupDone()

