
from Ft.Ods import Collections
from Ft.Ods.Collections import Iterator


def test_unstable_iterator(c,values,toRemove):

    i = c.create_iterator(0)

    if i.is_stable() != 0:
        raise "is_stable failed"

    if i.at_end():
        raise "at_end failed"

    if i.get_element() != values[0]:
        raise "get_element failed"
    
    i.next_position()

    if i.get_element() != values[1]:
        raise "next_position failed"

    i.next_position()

    if not i.at_end():
        raise "at_end failed"

    i.reset()

    if i.get_element() != values[0]:
        raise "reset failed"

    c.remove_element(toRemove)

    i.next_position()

    if not i.at_end():
        raise "stability here"

    try:
        i.next_position()
    except Iterator.NoMoreElements, e:
        pass
    else:
        raise "No exception thrown"



    print "UnStable Iterator works"


def test_stable_iterator(c,values,toRemove):

    i = c.create_iterator(1)

    if i.is_stable() != 1:
        raise "is_stable failed"

    if i.at_end():
        raise "at_end failed"

    if i.get_element() != values[0]:
        raise "get_element failed"
    
    i.next_position()

    if i.get_element() != values[1]:
        raise "next_position failed"

    i.next_position()

    if not i.at_end():
        raise "at_end failed"

    i.reset()

    if i.get_element() != values[0]:
        raise "reset failed"

    c.remove_element(toRemove)

    i.next_position()
    i.next_position()

    if not i.at_end():
        raise "No stability here"


    try:
        i.next_position()
    except Iterator.NoMoreElements, e:
        pass
    else:
        raise "No exception thrown"


    print "Stable Iterator works"



def test_bidirectional_iterator(c,values):

    i = c.create_bidirectional_iterator(1)

    if not i.at_beginning():
        raise "at_beginning failed"

    i.next_position()

    if i.at_beginning():
        raise "at_beginning failed"

    i.previous_position()

    if not i.at_beginning():
        raise "previous posiiton failed"

    if i.get_element() != values[0]:
        raise "previous position failed"

    print "Bidirectional iterator works"


def test_iterator(c,values,toRemove = None):

    if toRemove == None:
        toRemove = values[1]

    test_stable_iterator(c.copy(deep=1),values,toRemove)
    test_unstable_iterator(c.copy(deep=1),values,toRemove)



def test():


    from Ft.Ods.Collections import LiteralListOfValues

    l = LiteralListOfValues.LiteralListOfValues()

    print "Test LiteralListOfValues"

    values = ['TEST1','TEST2','TEST3']

    for v in values:
        l.insert_element_last(v)

    test_iterator(l,values)
    test_bidirectional_iterator(l,values)


    #print "Test DictionaryOfLiteralValues"

    #from Ft.Ods.Collections import LiteralDictionaryOfValues

    #l = LiteralDictionaryOfValues.LiteralDictionaryOfValues(type(1),type(""))

    #keys = [1,2,3]
    #values = ['TEST1','TEST2','TEST3']

    #for ctr in range(3):
    #    l[keys[ctr]] = values[ctr]

    #test_iterator(l,l.values(),Collections.Association(keys[1],values[1]))
    #test_bidirectional_iterator(l,l.values())



    #from Ft.Ods import Database
    #db = Database.Database()
    #db.open('test')
    #tx = db.new()

    #tx.begin()

    #print "Test DictionaryOfLiteralRepositoryObjects"

    #from Ft.Ods.MetaData import PrimitiveType
    #from Ft.Ods.Collections import LiteralDictionaryOfRepositoryObjects

    #l = LiteralDictionaryOfRepositoryObjects.LiteralDictionaryOfRepositoryObjects(type(""),PrimitiveType.PrimitiveType)

    #keys = ['pk_long','pk_string','pk_boolean']

    #for key in keys:
    #    l[key] = db.schema().resolve(key)

    #test_iterator(l,l.values(),Collections.Association(keys[1],l[keys[1]]))
    #test_bidirectional_iterator(l,l.values())







if __name__ == '__main__':

    test()
