DB_NAME = 'test'


from Ft.Lib import DbmDatabase



def test_create(tester):

    tester.startTest("Database Creation")
    if DbmDatabase.DatabaseExists(DB_NAME):
        DbmDatabase.DropDatabase(DB_NAME)

    before = DbmDatabase.GetAllDatabaseNames()
    db = DbmDatabase.CreateDatabase(DB_NAME)
    after = DbmDatabase.GetAllDatabaseNames()

    tester.compare(len(before)+1, len(after))
    tester.compare(1, after.count(DB_NAME))
    tester.testDone()
    return

def test_drop(tester):

    
    tester.startTest("Drop Database")
    before = DbmDatabase.GetAllDatabaseNames()
    try:
        DbmDatabase.DropDatabase(DB_NAME)
    except Exception, error:
        tester.error(str(error))
    else:
        after = DbmDatabase.GetAllDatabaseNames()
        tester.compare(len(before)-1, len(after))
        tester.compare(0, after.count(DB_NAME))
    tester.testDone()
    return

def test_table_create(tester):

    tester.startGroup("Create Table")

    tester.startTest("Create DB")
    DbmDatabase.CreateDatabase(DB_NAME)
    tester.testDone()
    
    tester.startTest("Create and Rollback")
    db = DbmDatabase.Database(DB_NAME)
    t = db.createTable('table1')
    res = db.getAllTableNames()
    tester.compare(1,len(res))
    tester.compare(1,res.count('table1'))
    db.rollback()

    db = DbmDatabase.Database(DB_NAME)
    res = db.getAllTableNames()
    tester.compare(0,len(res))
    db.rollback()
    tester.testDone()

    tester.startTest("Create and Commit")
    db = DbmDatabase.Database(DB_NAME)
    t = db.createTable('table1')
    res = db.getAllTableNames()
    tester.compare(1,len(res))
    tester.compare(1,res.count('table1'))
    db.commit()
    db = DbmDatabase.Database(DB_NAME)
    res = db.getAllTableNames()
    tester.compare(1,len(res))
    tester.compare(1,res.count('table1'))
    db.rollback()
    tester.testDone()
    tester.groupDone()

def test_get_table(tester):

    tester.startGroup("Get Table")

    tester.startTest("getTable")

    db = DbmDatabase.Database(DB_NAME)

    t = db.getTable('table1')

    tester.testDone()

    tester.startTest("pythonic interface")
    t = db['table1']
    res = db.keys()
    tester.compare(1,len(res))
    tester.compare(1,res.count('table1'))
    db.rollback()
    tester.testDone()
    tester.groupDone()


def test_table_insert(tester):

    tester.startGroup("Table Insert")

    tester.startTest("Insert in new table, rollback")

    db = DbmDatabase.Database(DB_NAME)
    t = db.createTable('table2')
    db.commit()

    db = DbmDatabase.Database(DB_NAME)
    t = db['table2']
    t['key1'] = "Foo"

    tester.compare("Foo",t['key1'])
    res = t.keys()
    tester.compare(1,len(res))
    tester.compare(1,res.count('key1'))
    tester.compare(1,t.has_key('key1'))
    tester.compare("Foo",t.get('key1'))
    tester.compare(None,t.get('key2'))
    tester.compare(1,len(t))
    db.rollback()

    db = DbmDatabase.Database(DB_NAME)
    db = DbmDatabase.Database(DB_NAME)
    t = db['table2']
    res = t.keys()
    tester.compare(0,len(res))
    tester.compare(0,t.has_key('key1'))
    tester.compare(None,t.get('key1'))
    tester.compare(0,len(t))
    db.rollback()


    tester.testDone()

    tester.startTest("Insert in new table, commit")

    db = DbmDatabase.Database(DB_NAME)
    t = db['table2']
    t['key1'] = "Foo"

    tester.compare("Foo",t['key1'])
    res = t.keys()
    tester.compare(1,len(res))
    tester.compare(1,res.count('key1'))
    tester.compare(1,t.has_key('key1'))
    tester.compare("Foo",t.get('key1'))
    tester.compare(None,t.get('key2'))
    tester.compare(1,len(t))
    db.commit()

    db = DbmDatabase.Database(DB_NAME)
    t = db['table2']
    tester.compare(1,len(res))
    tester.compare(1,res.count('key1'))
    tester.compare(1,t.has_key('key1'))
    tester.compare("Foo",t.get('key1'))
    tester.compare(None,t.get('key2'))
    tester.compare(1,len(t))
    db.rollback()


    tester.testDone()

    tester.groupDone()

def test_table_delete(tester):

    tester.startGroup("Table Delete")

    tester.startTest("Delete from table, rollback")

    db = DbmDatabase.Database(DB_NAME)
    t = db.createTable('table3')
    t['key1'] = "Foo"
    db.commit()

    db = DbmDatabase.Database(DB_NAME)
    t = db['table3']
    del t['key1']

    res = t.keys()
    tester.compare(0,len(res))
    tester.compare(0,t.has_key('key1'))
    tester.compare(None,t.get('key1'))
    tester.compare(0,len(t))
    db.rollback()


    db = DbmDatabase.Database(DB_NAME)
    t = db['table3']
    tester.compare("Foo",t['key1'])
    res = t.keys()
    tester.compare(1,len(res))
    tester.compare(1,res.count('key1'))
    tester.compare(1,t.has_key('key1'))
    tester.compare("Foo",t.get('key1'))
    tester.compare(None,t.get('key2'))
    tester.compare(1,len(t))
    db.commit()



    tester.testDone()

    tester.startTest("Delete from table, commit")

    db = DbmDatabase.Database(DB_NAME)
    t = db['table3']
    del t['key1']

    res = t.keys()
    tester.compare(0,len(res))
    tester.compare(0,t.has_key('key1'))
    tester.compare(None,t.get('key1'))
    tester.compare(0,len(t))
    db.commit()

    db = DbmDatabase.Database(DB_NAME)
    t = db['table3']
    tester.compare(0,len(res))
    tester.compare(0,t.has_key('key1'))
    tester.compare(None,t.get('key1'))
    tester.compare(0,len(t))
    db.commit()
    tester.testDone()

    tester.groupDone()



def Test(tester):
    test_create(tester)
    test_drop(tester)
    test_table_create(tester)
    test_get_table(tester)
    test_table_insert(tester)
    test_table_delete(tester)

    # Cleanup after ourselves
    if DbmDatabase.DatabaseExists(DB_NAME):
        DbmDatabase.DropDatabase(DB_NAME)
    return
