import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity3.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python relationship_test.py
#

import os,sys
import test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants


odl_string = """

module Test {

class Person (extent people)
{
	attribute string name;
        attribute string ssn;
        relationship list<Person> influenced_from inverse Person :: influences;
        relationship list<Person> influences inverse Person :: influenced_from;
};

class Professor;

class Student extends Person
{
	relationship Professor learns_from inverse Professor :: teaches;
};

class Professor extends Person
{
	relationship list<Student> teaches inverse Student :: learns_from;
};

};
"""
#"
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass

def _Test(tester):


    tester.startGroup('Relationship Test %s Driver' % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Person
        from Test import Professor
        from Test import Student
    except:
        tester.error('Error in syntax', 1)
    reload(Person)
    reload(Professor)
    reload(Student)

    tester.testDone()

    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()


    tester.startTest('Create the classes')

    p = Professor.new(db)
    s = Student.new(db)

    sInfluenced = Student.new(db)

    p.name = "Prof"
    s.name = "Stud"
    sInfluenced.name = "Inf"

    s.learns_from = p
    p.add_influences(sInfluenced)

    tx.commit()
    tester.testDone()
    

    pId = p._4ods_getId()
    sId = s._4ods_getId()
    iId = sInfluenced._4ods_getId()



    tester.startTest("Test the relationships")
    tx = db.new()
    tx.begin()

    p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,pId)
    s = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,sId)
    i = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,iId)


    tester.testResults(p,s.learns_from,done=0,msg="Invalid Learns from")
    tester.testResults(s,p.teaches[0],done=0,msg="Invalid teaches")
    tester.testResults(i,p.influences[0],done=0,msg="Invalid influences")
    tester.testResults(p,i.influenced_from[0],done=0,msg="Invalid influenced_from")

    tester.testDone()

    tx.abort()

    tx = db.new()
    tx.begin()

    tester.startTest("Test dropping relationships")

    p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,pId)
    s = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,sId)
    i = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,iId)

    del p.influences
    tester.testResults(len(p.influences),0,done=0,msg="Too many influnces")
    del s.learns_from
    tester.testResults(s.learns_from,None,done=0,msg="Learns from not deleted")

    tx.abort()
    db.close()

    tester.testDone()
    tester.groupDone()

if __name__ == '__main__':

    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

