########################################################################
#
# File Name:            ParamElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/ParamElement.py.html
#
"""
Implementation of the XSLT Spec param stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import xml.dom.ext
from xml.dom import Node
import xml.xslt
from xml.xslt import XsltElement, XsltException, Error, VariableElement, XSL_NAMESPACE
from xml.xpath import CoreFunctions, Util

#Note: Variable is being mixed in for the private _register method
class ParamElement(XsltElement, VariableElement.VariableElement):
    legalAttrs = ('name', 'select')

    def __init__(self, doc, uri=xml.xslt.XSL_NAMESPACE, localName='param', prefix='xsl', baseUri=''):
        XsltElement.__init__(self, doc, uri, localName, prefix, baseUri)

    def setup(self):
        self._nss = xml.dom.ext.GetAllNs(self)
        name_attr = self.getAttributeNS('', 'name')
        self._name = Util.ExpandQName(
            name_attr,
            namespaces=self._nss
            )
        self._select = self.getAttributeNS('', 'select')
        if self._select:
            self._expr = self.parseExpression(self._select)
        else:
            self._expr = None
        pn = self.parentNode
        if not(pn.nodeType == Node.ELEMENT_NODE and \
               pn.namespaceURI == XSL_NAMESPACE and \
               pn.localName in ['stylesheet', 'transform', 'template']):
            raise XsltException(Error.ILLEGAL_PARAM_PARENT,self.baseUri,self._ft_lineNumber,self._ft_columnNumber)
        self._register()
        return

    def instantiate(self, context, processor):
        origState = context.copy()
        context.setNamespaces(self._nss)
        context.currentInstruction = self

        if self._select:
            result = self._expr.evaluate(context)
        else:
            processor.pushResult()
            try:
                for child in self.childNodes:
                    context = child.instantiate(context, processor)[0]
            finally:
                result = processor.popResult()
            context.rtfs.append(result)

        context.set(origState)
        #Because of the in-place mutability of dicts, we have to copy off
        #to avoid illegal side-effects
        new_bindings = context.varBindings.copy()
        new_bindings[self._name] = result
        context.varBindings = new_bindings
        return (context,)

    def __getinitargs__(self):
        return (None, self.namespaceURI, self.localName, self.prefix, self.baseUri)

    def __getstate__(self):
         base_state = XsltElement.__getstate__(self)
         new_state = (base_state, self._nss, self._name, self._select, self._expr)
         return new_state

    def __setstate__(self, state):
        XsltElement.__setstate__(self, state[0])
        self._nss = state[1]
        self._name = state[2]
        self._select = state[3]
        self._expr = state[4]
        return

