## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 2003 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2002 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2001 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2000 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
## All Rights Reserved.
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus@oberhumer.com>
## http://www.oberhumer.com/pysol
##
##---------------------------------------------------------------------------##


# imports
import os, sys, Tkinter

# PySol imports
from mfxtools import *
from mfxutil import destruct, kwdefault, KwStruct, Struct

# Toolkit imports
from tkconst import EVENT_HANDLED, EVENT_PROPAGATE
from tkwidget import _ToplevelDialog, MfxDialog, MfxSimpleSlider


# /***********************************************************************
# //
# ************************************************************************/

class PlayerOptionsDialog(MfxDialog):
    def __init__(self, parent, title, app, **kw):
        kw = self.initKw(kw)
        _ToplevelDialog.__init__(self, parent, title, kw.resizable, kw.default)
        top_frame, bottom_frame = self.createFrames(kw)
        self.createBitmaps(top_frame, kw)
        #
        self.update_stats_var = Tkinter.BooleanVar()
        self.update_stats_var.set(app.opt.update_player_stats != 0)
        self.confirm_var = Tkinter.BooleanVar()
        self.confirm_var.set(app.opt.confirm != 0)
        self.win_animation_var = Tkinter.BooleanVar()
        self.win_animation_var.set(app.opt.win_animation != 0)
        #
        widget = Tkinter.Label(top_frame, text="\nPlease enter your name", takefocus=0)
        widget.pack(pady=5)
        w = kw.get("e_width", 30)    # width in characters
        self.player_var = Tkinter.Entry(top_frame, exportselection=1, width=w)
        self.player_var.insert(0, app.opt.player)
        self.player_var.pack(side=Tkinter.TOP, padx=kw.padx, pady=kw.pady)
        widget = Tkinter.Checkbutton(top_frame, variable=self.confirm_var,
                                     text="Confirm quit")
        widget.pack(side=Tkinter.TOP, padx=kw.padx, pady=kw.pady)
        widget = Tkinter.Checkbutton(top_frame, variable=self.update_stats_var,
                                     text="Update statistics and logs")
        widget.pack(side=Tkinter.TOP, padx=kw.padx, pady=kw.pady)
###        widget = Tkinter.Checkbutton(top_frame, variable=self.win_animation_var,
###                                     text="Win animation")
###        widget.pack(side=Tkinter.TOP, padx=kw.padx, pady=kw.pady)
        #
        self.player = self.player_var.get()
        self.confirm = self.confirm_var.get()
        self.update_stats = self.update_stats_var.get()
        self.win_animation = self.win_animation_var.get()
        #
        focus = self.createButtons(bottom_frame, kw)
        self.mainloop(focus, kw.timeout)

    def mDone(self, button):
        self.button = button
        self.player = ustr(self.player_var.get())
        self.confirm = self.confirm_var.get()
        self.update_stats = self.update_stats_var.get()
        self.win_animation = self.win_animation_var.get()
        raise SystemExit


    def initKw(self, kw):
        kw = KwStruct(kw,
            strings=("OK", "Cancel"), default=0,
            separatorwidth=2, resizable=1,
            padx=10, pady=10,
        )
        return MfxDialog.initKw(self, kw)


# /***********************************************************************
# //
# ************************************************************************/


def playeroptionsdialog_main(args):
    from tkutil import wm_withdraw
    opt = Struct(player="Test", update_player_stats=1)
    app = Struct(opt=opt)
    tk = Tkinter.Tk()
    wm_withdraw(tk)
    tk.update()
    d = PlayerOptionsDialog(tk, "Player options", app)
    print d.status, d.button, ":", d.player, d.update_stats
    return 0

if __name__ == "__main__":
    import sys
    sys.exit(playeroptionsdialog_main(sys.argv))

