## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 2000 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus@oberhumer.com>
## http://www.oberhumer.com/pysol
##
##---------------------------------------------------------------------------##


# imports
import sys

# PySol imports
if sys.modules.has_key("pysoltk"):
    from gamedb import registerGame, GameInfo, GI
    from util import *
    from stack import *
    from game import Game
    from layout import Layout
    from hint import AbstractHint, DefaultHint, CautiousDefaultHint


# /***********************************************************************
# //
# ************************************************************************/

class PileOn_RowStack(RK_RowStack):
    def getBottomImage(self):
        return self.game.app.images.getReserveBottom()


class PileOn(Game):
    Hint_Class = DefaultHint
    ##Hint_Class = CautiousDefaultHint

    #
    # game layout
    #

    def createGame(self, playcards=4):
        # create layout
        l, s = Layout(self, XOFFSET=16), self.s

        # set window
        # (set size so that at least 4 cards are fully playable)
        w = max(2*l.XS, l.XS+(playcards-1)*l.XOFFSET+2*l.XM)
        self.setSize(l.XM+4*w, l.YM + 4*l.YS)

        # create stacks
        y = l.YM
        for i in range(4):
            x = l.XM
            for j in range(4):
                stack = PileOn_RowStack(x, y, self, dir=0, max_cards=4)
                stack.CARD_XOFFSET, stack.CARD_YOFFSET = l.XOFFSET, 0
                s.rows.append(stack)
                x = x + w
                if i == 3 and j == 2:
                    break
            y = y + l.YS
        x, y = self.width - l.XS, self.height - l.YS
        s.talon = InitialDealTalonStack(x, y, self)

        # define stack-groups
        self.sg.openstacks = s.rows
        self.sg.talonstacks = [s.talon]
        self.sg.dropstacks = s.rows

    #
    # game overrides
    #

    def startGame(self):
        r = self.s.rows[:13]
        for i in range(3):
            self.s.talon.dealRow(rows=r, frames=0)
        self.startDealSample()
        self.s.talon.dealRow(rows=r)
        assert len(self.s.talon.cards) == 0

    def isGameWon(self):
        for r in self.s.rows:
            if r.cards:
                if len(r.cards) != 4 or not r._isSequence(r.cards):
                    return 0
        return 1

    def shallHighlightMatch(self, stack1, card1, stack2, card2):
        return card1.rank == card2.rank


# register the game
registerGame(GameInfo(41, PileOn, "PileOn",
                      GI.GT_1DECK_TYPE, 1, 0))

