# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import os
import gtk
import vte

from dlgBase import DlgBase
from prefsManager import prefs

class DlgOutput(DlgBase) :

    def __init__(self, parent) :
        DlgBase.__init__(self, parent, 'dlg-output', ['btnClose', 'btnStop', 'vteOutput'])

        self.wTree.signal_autoconnect(self)

        self.vteOutput.show_all()
        self.vteOutput.connect('child-exited', self.onVTEChildExited)

        self.mDlg.resize(prefs.outputDlgWidth, prefs.outputDlgHeight)        


    def onVTEChildExited(self, terminal) :
        self.btnClose.set_sensitive(True)
        self.btnStop.set_sensitive(False)


    def getCustomHandler(self, glade, function_name, widget_name, str1, str2, int1, int2) :
        if function_name == 'createVTE' :
            return vte.Terminal()


    def onBtnStop(self, widget) :
        os.kill(self.mCmdPid, 9)


    def onDlgResize(self, window, rectangle) :
        prefs.outputDlgWidth  = rectangle.width
        prefs.outputDlgHeight = rectangle.height


    def onResponse(self, dialog, response, *args) :
        if response == gtk.RESPONSE_CLOSE :
            DlgBase.onResponse(self, dialog, response, args)
        else :
            self.mDlg.stop_emission('response')


    def show(self, cmd, args) :
        self.btnClose.set_sensitive(False)
        self.btnStop.set_sensitive(True)
        self.mDlg.show()
        self.mCmdPid = self.vteOutput.fork_command(cmd, args)


dlg = None
def instance(parent) :
    global dlg
    if dlg is None :
        dlg = DlgOutput(parent)
    return dlg
