# File: popbox.py
# Purpose: pop3 inbox class
# obsolete.

from gtk import *

import socket
import poplib
import smtplib
import string

from pyneheaders import *
import superbox
import boxformats
import boxformats.configbox
import msgfilter
from ptk.big_edit_box import *

class popbox(superbox.superbox):
	"""
	Pop3 inbox.
	"""
	def get_flags(self):
		return 1
	
	def __init__(self, user, name, uid):
		"""
		Create new pop inbox.
		"""

		# Basic setup
		superbox.superbox.__init__(self, name, uid)
		self.server = "pop.someisp.com"
		self.smtpserver = "smtp.someisp.com"
		self.port = 110
		self.smtpport = 25
		self.username = ""
		self.password = ""
		self.realname = "your name"
		self.emailaddr = "someguy@some.com"
		self.replyto = ""
		self.org = ""
		self.sigfile = "~/.signature"
		self.expire_after = None
		self.export_format = (boxformats.BF_FLATFILEBOX, None)

		self.contents = [] # sub-folders
		self.messages = []
		self.filters = []

		self.startup(user)

	def clean_4_save(self):
		"""
		Remove stuff we don't want saved to disk
		"""
		if self.__dict__.has_key("locked"):
			del self.locked
		if self.__dict__.has_key("changed"):
			del self.changed
		del self.io
		del self.messages

	def startup(self, user):
		"""
		Get an io module for loading/saving articles
		"""
		i = self.export_format[0]
		# this is a pretty piece of code :-)
		bf_class = boxformats.__dict__[boxformats.__all__[i]]. \
			   __dict__[boxformats.__all__[i]]
		self.io = bf_class(user, self)
		self.messages = self.io.get_contents()

	def getstats(self):
		"""
		Returns message to be put in 'items' field of mailbox view.
		"""
		return (len(self.messages),)

	def get_menu(self):
		"""
		This folder type specific options.
		"""
		return []
	
	def menu_chosen(self, _a, choice):
		return

	def post_message(self, connection, msg):
		"""
		Post message 'msg' with SMTP connection.
		"""
		# make list of target addresses
		adds = string.split(msg.headers["to"], ",")
		if msg.headers.has_key("cc"):
			adds = adds + string.split(msg.headers["cc"], ",")
		if msg.headers.has_key("bcc"):
			adds = adds + string.split(msg.headers["bcc"], ",")
		# clean up
		for i in range(0, len(adds)):
			adds[i] = string.strip(adds[i])
		connection.sendmail(msg.headers["from"], adds, msg.body)

	def get_connection(self, pop=0):
		"""
		Return a connection object. if pop=0: smtp, pop=1: pop3.
		"""
		if pop == 0:
			# establish smtp connection
			c = smtplib.SMTP(self.smtpserver, self.smtpport)
			return c
		else:
			# establish pop3 connection
			c = poplib.POP3(self.server, self.port)
			return c

	def setup(self, parent_user):
		"""
		Configure a mailbox.
		"""
		win = GtkWindow()
		win.set_title(self.name+" Setup")

		box = GtkVBox()
		box.set_border_width(5)
		win.add(box)
		box.show()

		notebook = GtkNotebook()
		notebook.set_tab_pos(POS_TOP)
		box.pack_start(notebook)
		notebook.show()
	
		# First page: Misc settings
		settings_box0 = big_edit_box( self,
		      ( ("name", "Name:", VAR_TYPE_STRING, 0, 0),
			("server", "POP server:", VAR_TYPE_STRING, 0, 0),
			("port", "Port:", VAR_TYPE_INTEGER, 0, 110),
			("smtpserver", "SMTP server:", VAR_TYPE_STRING, 0, 0),
			("smtpport", "Port:", VAR_TYPE_INTEGER, 0, 25),
			("username", "Username:", VAR_TYPE_STRING, 0, 0),
			("password", "Password:", VAR_TYPE_STRING, MOD_HIDE, 0),
			("realname", "Real name:", VAR_TYPE_STRING, 0, 0),
			("emailaddr", "Email address", VAR_TYPE_STRING, 0, 0),
			("replyto", "Reply to:", VAR_TYPE_STRING, 0, 0),
			("sigfile", "Signature file:", VAR_TYPE_STRING, 0, 0),
			("expire_after", "Expire after (days):", VAR_TYPE_INTEGER, 0, None),
			("opts", "Thread messages", VAR_TYPE_PACKED_BIT_BOOLEAN, 0, superbox.OPT_THREAD) )
		)
		label = GtkLabel("Settings")
		notebook.append_page(settings_box0, label)
		settings_box0.show()
		
		# 2nd page: mail filters
		label = GtkLabel("Filters")
		filterbox = msgfilter.filter_editbox(self, parent_user)
		notebook.append_page(filterbox, label)
		filterbox.show()

		# 3rd page: storage method
		label = GtkLabel("Mailbox Format")
		formatbox = boxformats.configbox.configbox(self, parent_user)
		notebook.append_page(formatbox, label)
		formatbox.show()

		def save_changes(_button, filterbox=filterbox, self=self, \
				parent_user=parent_user, win=win, settings_box0 = settings_box0):
			# Extract info
			settings_box0.apply_changes()
			self.filters = filterbox.filters
			# update folder list
			self.changed = 1
			parent_user.update()
			win.destroy()

		# Seperator between entry boxes and buttons
		separator = GtkHSeparator()
		box.pack_start(separator, expand=FALSE)
		separator.show()

		# Buttons at bottom
		lastbox = GtkHBox(spacing=5)
		lastbox.set_border_width(10)
		box.pack_start(lastbox, expand=FALSE)
		lastbox.show()

		cancel_button = GtkButton(" Cancel ")
		cancel_button.connect("clicked", win.destroy)
		lastbox.pack_end(cancel_button, expand=FALSE)
		cancel_button.show()

		ok_button = GtkButton(" Ok ")
		ok_button.connect("clicked", save_changes)
		lastbox.pack_end(ok_button, expand=FALSE)
		ok_button.show()

		win.show()

	def remote_get_header(self, POP3_obj, index):
		"""
		Return header of message 'index' in pop3 box.
		"""
		lines = POP3_obj.top(index, 0)[1]
		head = string.join(lines, "\n")
		return head

	def remote_get_body(self, POP3_obj, index):
		"""
		return body of message 'index' in pop3 box.
		"""
		lines = POP3_obj.retr(index)[1]
		body = string.join(lines, "\n")
		# seperate body from header and return
		start = string.find(body, "\n\n") + 2
		return body[start:]

	def remote_delete(self, POP3_obj, index):
		"""
		delete message from remote pop3 inbox.
		"""
		POP3_obj.dele(index)

	def update(self, parent_user, pager):
		"""
		Update the box. Collect mail from pop3 server.
		"""
		self.locked = 1
		# If no pop server is designated abort collection
		if string.strip(self.server) == "":
			del self.locked
			return
		threads_enter()
		progressbar = pager.get_progress_bar()
		progressbar.set_format_string("Collecting "+self.name+" mail")
		msg_print = pager.msg_print
		msg_print("<%s> Connecting to " % self.name + self.server+"...")
		threads_leave()

		try:
			# Connect to server
			p = self.get_connection(pop=1)
		except socket.error, e:
			threads_enter()
			msg_print("<%s> Error: " % self.name + str(e.args[0]))
			progressbar.destroy()
			threads_leave()
			del self.locked
			return

		threads_enter()
		msg_print("<%s> Verifying username and password" % self.name)
		threads_leave()

		try:
			# Verify username & password
			p.user(self.username)
			p.pass_(self.password)
		except:
			p.quit()
			threads_enter()
			msg_print("<%s> Error: Login incorrect" % self.name)
			threads_leave()
			del self.locked
			return

		# store nice listy thing of messages to collect
		# in form ('+OK ', ['num1 size', 'num2 size'], some number)
		self.pop3_msglist = p.list()
		nummsgs = len( self.pop3_msglist[1] )

		# Start collecting
		for i in range(nummsgs):
			#s = "<%s> Collecting message " % self.name +str(i+1)+"/"+str(nummsgs)
			threads_enter()
			#msg_print(s)
			progressbar.set_percentage(i/float(nummsgs))
			progressbar.set_format_string("%d/%d of " % (i, nummsgs) + self.name)
			threads_leave()

			msg = msgfilter.filter_collect(parent_user, self, p, i+1)
			if msg != "":
				threads_enter()
				msg_print(msg)
				threads_leave()
		p.quit()

		threads_enter()
		msg_print("<%s> " % self.name + str(nummsgs)+" messages collected.")
		progressbar.destroy()
		threads_leave()

		threads_enter()
		self.changed = 1
		parent_user.update()
		threads_leave()

		del self.pop3_msglist
		del self.locked
