# The MIT License
#
# Permission is hereby granted, free of charge, to any person 
# obtaining a copy of this software and associated documentation 
# files (the "Software"), to deal in the Software without 
# restriction, including without limitation the rights to use, 
# copy, modify, merge, publish, distribute, sublicense, and/or 
# sell copies of the Software, and to permit persons to whom the 
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included 
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
# DEALINGS IN THE SOFTWARE.


"""
-----------
README:

This source file is a modified version of autopath.py taken
from pypy :

http://codespeak.net/svn/pypy/dist/pypy/tool/autopath.py

It has just been modified to fit with pyinotify.

USAGE: in order to use this script, edit it
- root_dir: set the root directory of your project
- this_dir: set the location of writable version of this script

------------
self cloning, automatic path configuration

copy this into any subdirectory of pypy from which scripts need
to be run, typically all of the test subdirs.
The idea is that any such script simply issues

    import autopath

and this will make sure that the parent directory containing 'src'
is in sys.path.

If you modify the master version (in src/autopath.py) you can
directly run it which will copy itself on all autopath.py files
it finds under the src root directory.

This module always provides these attributes:

    root_dir    src root directory path
    this_dir   directory where this autopath.py resides


"""


def __dirinfo(part):
    """ return (partdir, this_dir) and insert parent of partdir
    into sys.path.  If the parent directories don't have the part
    an EnvironmentError is raised."""

    import sys, os
    try:
        head = this_dir = os.path.realpath(os.path.dirname(__file__))
    except NameError:
        head = this_dir = os.path.realpath(os.path.dirname(sys.argv[0]))

    while head:
        partdir = head
        head, tail = os.path.split(head)
        if tail == part:
            break
    else:
        raise EnvironmentError, "'%s' missing in '%r'" % (partdir, this_dir)

    checkpaths = sys.path[:]
    d_root = os.path.join(head, '')

    while checkpaths:
        orig = checkpaths.pop()
        fullorig = os.path.join(os.path.realpath(orig), '')
        if fullorig.startswith(d_root):
            if os.path.exists(os.path.join(fullorig, '__init__.py')):
                sys.path.remove(orig)
    if head not in sys.path:
        sys.path.insert(0, head)

    munged = {}
    for name, mod in sys.modules.items():
        fn = getattr(mod, '__file__', None)
        if '.' in name or not isinstance(fn, str):
            continue
        newname = os.path.splitext(os.path.basename(fn))[0]
        if not newname.startswith(part + '.'):
            continue
        path = os.path.join(os.path.dirname(os.path.realpath(fn)), '')
        if path.startswith(d_root) and newname != part:
            modpaths = os.path.normpath(path[len(d_root):]).split(os.sep)
            if newname != '__init__':
                modpaths.append(newname)
            modpath = '.'.join(modpaths)
            if modpath not in sys.modules:
                munged[modpath] = mod

    for name, mod in munged.iteritems():
        if name not in sys.modules:
            sys.modules[name] = mod
        if '.' in name:
            prename = name[:name.rfind('.')]
            postname = name[len(prename)+1:]
            if prename not in sys.modules:
                __import__(prename)
                if not hasattr(sys.modules[prename], postname):
                    setattr(sys.modules[prename], postname, mod)

    return partdir, this_dir

def __clone():
    """ clone master version of autopath.py into all subdirs """
    from os.path import join, walk
    if not this_dir.endswith(join('src','pyinotify')):
        raise EnvironmentError("can only clone master version "
                               "'%s'" % join(root_dir, 'pyinotify',_myname))


    def sync_walker(arg, dirname, fnames):
        if _myname in fnames:
            fn = join(dirname, _myname)
            f = open(fn, 'rwb+')
            try:
                if f.read() == arg:
                    print "checkok", fn
                else:
                    print "syncing", fn
                    f = open(fn, 'w')
                    f.write(arg)
            finally:
                f.close()
    s = open(join(root_dir, 'pyinotify', _myname), 'rb').read()
    walk(root_dir, sync_walker, s)

_myname = 'autopath.py'

# set guaranteed attributes

root_dir, this_dir = __dirinfo('src')

if __name__ == '__main__':
    __clone()
