# -*- coding: iso-8859-1 -*-
#
# rec.py - example of ProcessEvent subclassing
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

import os

# please read src/examples/README
try:
    # import local build
    import autopath
    from src.pyinotify.pyinotify import ProcessEvent, EventsCodes
except ImportError:
    # import global (installed) pyinotify
    from pyinotify import ProcessEvent, EventsCodes


class PRec(ProcessEvent):
    """
    Add watches on every new directory
    """

    def __init__(self, inotify):
        # no need to call ProcessEvent.__init__(self)
        self._inotify = inotify


    def process_IN_CREATE(self, event_k):
        super(PRec, self).process_default(event_k, 'IN_CREATE')
        if event_k.isdir:
            self._inotify.add_watch(os.path.join(event_k.path, event_k.name),
                                    EventsCodes.ALL_EVENTS, proc_fun=self)

