#!/usr/bin/env ruby

$:.unshift("../lib").unshift("../../lib") if __FILE__ =~ /\.rb$/

require 'puppettest'
require 'puppet'
require 'facter'

class TestNameServiceProvider < Test::Unit::TestCase
    include PuppetTest::FileTesting

    def test_option
        klass = Class.new(Puppet::Type::Provider::NameService)
        klass.model = Puppet::Type.type(:user)

        val = nil
        assert_nothing_raised {
            val = klass.option(:home, :flag)
        }

        assert_nil(val, "Got an option")

        assert_nothing_raised {
            klass.options :home, :flag => "-d"
        }
        assert_nothing_raised {
            val = klass.option(:home, :flag)
        }
        assert_equal("-d", val, "Got incorrect option")
    end
end

# $Id: nameservice.rb 1793 2006-10-16 22:01:40Z luke $
