/* $Id: puf.c,v 1.1.1.1 2001/04/23 14:26:40 ossi Exp $ *
 *
 * puf 0.9  Copyright (C) 2000,2001 by Oswald Buddenhagen <puf@ossi.cjb.net>
 * based on puf 0.1.x (C) 1999,2000 by Anders Gavare <gavare@hotmail.com>
 *
 * You may modify and distribute this code under the terms of the GPL.
 * The is NO WARRANTY of any kind. See COPYING for details.
 *
 * puf.c - startup code and global functions
 *
 */

#include "puf.h"


int verbose = 0;
char *progname;
#ifdef DEBUG
int debug = 0;
#endif


#ifndef HAVE_SNPRINTF
/*  poor man's substitutes for the missing functions. not very cool ...  */

int vsnprintf(char *s, size_t n, char *fmt, va_list va)
{
    char buf[MAXBUFSIZE];
    int l;

    l = vsprintf(buf, fmt, va);
    if (l >= n)
	return -1;
    memcpy(s, buf, l + 1);
    return l;
}

int snprintf(char *s, size_t n, char *fmt, ...)
{
    int l;
    va_list va;

    va_start(va, fmt);
    l = vsnprintf(s, n, fmt, va);
    va_end(va);
    return l;
}

#endif

#ifndef HAVE_STRDUP

char *strdup(const char *s)
{
    int l = strlen(s) + 1;
    char *rt = malloc(l);
    if (rt)
	memcpy(rt, s, l);
    return rt;
}

#endif

int errm(url_t *u, char *msg, ...)
{
    char tbuf[SHORTSTR], fmt[SHORTSTR], *pt;
    int rtv, lv;
    va_list va;

    num_errors++;
    if (*msg == '!') {
	msg++;
	num_urls_fail++;
	rtv = RT_GIVEUP;
	lv = ERR;
    } else if (++u->attempt >= (unsigned)max_attempts) {
	num_urls_fail++;
	rtv = RT_GIVEUP;
	lv = ERR;
    } else {
	rtv = RT_RETRY;
	lv = WRN;
    }

    if (lv <= verbose) {
	if ((pt = strstr(msg, "$u"))) {
	    sprintf (fmt, u->port == 80 ? "%s" : "%s:%i",
		     u->host->name, u->port);
	    snprintf(tbuf, SHORTSTR, 
		     "%.*shttp://%s/%s%s", (int)(pt - msg), msg,
		     fmt, u->local_part, pt + 2);
	    pt = tbuf;
	} else
	    pt = msg;

	snprintf(fmt, SHORTSTR, 
		 rtv == RT_RETRY ? "%s warning: %s (try %d)\n" : "%s: %s\n", 
		 progname, pt, u->attempt);

	va_start(va, msg);
	vfprintf(stderr, fmt, va);
	va_end(va);
    }

    return rtv;
}

void dbp(char *msg, ...)
{
    char fmt[SHORTSTR];
    va_list va;

    snprintf(fmt, SHORTSTR, "%s debug: %s", progname, msg);
    va_start(va, msg);
    vfprintf(stderr, fmt, va);
    va_end(va);
}

void dbpe(char *msg, ...)
{
    va_list va;

    va_start(va, msg);
    vfprintf(stderr, msg, va);
    va_end(va);
}

void prx(int lev, char *msg, ...)
{
    char fmt[SHORTSTR];
    static char *prfs[] = {" fatal", "", " warning", " info", " debug"};
    va_list va;

    if (lev <= verbose) {
	snprintf(fmt, SHORTSTR, "%s%s: %s", progname, prfs[lev], msg);
	va_start(va, msg);
	vfprintf(stderr, fmt, va);
	va_end(va);
    }
}

/*  print an error message and terminate  */
void die(int ret, char *msg, ...)
{
    char fmt[SHORTSTR];
    va_list va;

    snprintf(fmt, SHORTSTR, "\n%s: %s\n", progname, msg);
    va_start(va, msg);
    vfprintf(stderr, fmt, va);
    va_end(va);
    exit(ret);
}


#ifndef __DMALLOC_H__
/*  allocate memory or ask user what to do, if none available  */
void *mrealloc(void *ptr, size_t size)
{
    void *t;
    static int asked = 0;

    if (size <= 0 || size > 100000) {
#if 1
	*(char *)0 = 0;		/*  to bail out in a debugger  */
#else
	die(2, "Internal error: Invalid memory allocation request.\n");
#endif
    }
    if (!(t = realloc(ptr, size))) {
	if (!asked && isatty(0) && isatty(2)) {
	    prx(0, "Out of memory. Strange things may happen. Continue [n]? ");
	    if (getchar() != 'y')
		exit(1);
	    asked++;
	} else
	    prx(ERR, "Allocation of %d bytes failed!\n", size);
    }
    return t;
}

void *mmalloc(size_t size)
{
    return mrealloc(0, size);
}
#endif

long crc32_tab[256];

void init_hash(void)
{
    int i, b;
    long by;

    for (i = 0; i < 256; i++) {
	for (by = i, b = 0; b < 8; b++)
	    by = (by >> 1) ^ (-(by & 1) & 0xedb88320);
	crc32_tab[i] = by;
    }
}


/*  this is the normal crc32 algorithm. the generated numbers are quite
    unique, but i don't know, if they are well dispersed, i.e., if they are
    adequate for a real hash table.  */
int calc_hash(u_char * data, int len)
{
    int i;
    long crc = 0xc0debabe;

    for (i = 0; i < len; i++, data++)
	crc = (crc >> 8) ^ crc32_tab[(crc & 255) ^ *data];
    return (int)crc;
}

#ifdef USE_MAGIC
void magck(const char *msg)
{
    int i, f;
    url_t *u;
    for (u = urllist, i=1, f=0; u; u = u->next, i++) {
	if (u->chk != calc_hash((char *)&(u->len), u->len)) {
	    prx(ERR, ("%d fail: %s/%s\n", i, u->host->name, u->local_part));
	    f++;
	}
    }
    dbg(CHK, ("checked %d urls in %s\n", i-1, msg));
    if (f)
	die(10, "checksum errors in internal structures found");
}
#endif

int main(int argc, char *argv[])
{
#ifdef __DMALLOC_H__
    url_t *u, *nu;
    host_t *h, *nh;
    hinfo_t *hi;
#endif
    
    if (!isatty(1))
	show_stat = 0;
    else
	printf(PACKAGE " v" VERSION
	   "  Copyright (C) 2000,2001 by Oswald Buddenhagen\n"
	   "  based on puf v0.1.x  "
	     "Copyright (C) 1999,2000 by Anders Gavare\n");

    progname = strrchr(argv[0], '/');
    if (progname)
	progname++;
    else
	progname = argv[0];

    bind_addr.sin_family = AF_INET;	/*  the rest is already 0  */

    srand(time(0));

    init_hash();

    getopts(argc, argv);

    setlocale(LC_TIME, "C");	/*  some voodoo for strftime  */

    fetch_all();

#ifdef __DMALLOC_H__
    for (u = urllist; u; u = nu) {
	nu = u->next;
	dbg(MEM, ("disposing http://%s/%s\n", u->host->name, u->local_part));
	free(u);
    }
    for (hi = 0, h = hostlist; h; h = nh) {
	if (h->info != hi) {
	    hi = h->info;
	    if (hi) {
		dbg(MEM, ("disposing host info for '%s'\n", hi->name));
		free(hi);
	    }
	}
	nh = h->next;
	dbg(MEM, ("disposing host '%s'\n", h->name));
	free(h);
    }
#endif

    return 0;
}
