# types.py - type tests
#
# Copyright (C) 2001 Federico Di Gregorio  <fog@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# -*- Mode: pyhton -*-

print "Type singletons test"


# type names and expected types
types_type_names = ('NUMBER', 'STRING', 'DATETIME', 'BINARY', 'ROWID', 'MISSING')
types_type_objs = {}
types_expected = ('NUMBER', 'STRING', 'STRING', 'NUMBER', 'BINARY',
                  'DATETIME', 'DATETIME', 'DATETIME', 'NUMBER', 'STRING', 'ROWID')

# items in the description array
types_items = ('name', 'type_code', 'display_size', 'internal_size',
               'precision', 'scale', 'null_ok')

# first we check to see if the dba support all the five basic types
print "     a. Checking for singletons:"
for t in types_type_names:
    print "        %s..." % t,
    if hasattr(dba, t):
        ok("YES")
        types_type_objs[t] = getattr(dba, t)
    else:
        if t == 'MISSING':
            ok("YES (missing, as it should)")
        else:
            ko("NO")

o = dba.connect(DSN)

# now we do a select: it does not matter if we get any result, because
# we are only interested in the description filed of the cursor
print "     b. Doing a SELECT...",
try:
    c = o.cursor()
    c.execute("SELECT * FROM "+TABLE)
    ok("YES")
except dba.ProgrammingError, err:
    ko("ERROR")
    print err

# we check the cursor for the description field
print "     c. Checking description:"

print "        Exists:",
if hasattr(c, 'description'): ok("YES")
else: ko("NO")

types_desc = c.description

print "        Description columns (%d):" % len(TABLE_COLUMNS),
if len(types_desc) == len(TABLE_COLUMNS): ok("YES")
else: ko("NO (got %d)" % len(types_desc))

print "        Description size (7):",
if len(types_desc[0]) == 7: ok("YES")
else: ko("NO (got %d)" % len(types_desc[0]))


# and finally we check the types of all the columns returned
print "     d. Checking types:"
i = 0
for t in types_expected:
    try:
        print "        Type of column %s (%d) should be %s:" % \
              (types_desc[i][0], types_desc[i][1], t),  
        if not types_type_objs.has_key(t):
            ko("NO (missing type)")
        else:
            if types_type_objs[t] == types_desc[i][1]:
                ok("YES")
            else:
                ko("NO (inequality)")
    except:
        print "        Unable to access description for column %d:" % i,
        ko("ERROR")
    i = i+1


# extra checks on the description field, this time we compare the
# contents of the description with the expected values (ignoring any
# expected value of -1)

print "     e. Depth-checking description contents (item, real, expected):"
for i in range(len(types_desc)):
    try:
        print "        Checking column %s:" % types_desc[i][0],
        types_check_ok = 1
        for j in range(len(TABLE_DESCRIPTIONS[i])):
            v = TABLE_DESCRIPTIONS[i][j]
            if  v != -1 and v != types_desc[i][j]:
                ko("NO (%s, %s, %s)" % (types_items[j],
                                        str(types_desc[i][j]), str(v)))
                types_check_ok = 0
                break
        if types_check_ok:
            ok("YES")
    except:
        print "        Unable to access description for column %d:" % i,
        ko("ERROR")
                
