package PSP::Error::Group;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Group.pm,v 1.1 2000/11/23 23:36:19 muaddib Exp $

use strict;

use PSP::Error;
@PSP::Error::Group::ISA = qw(PSP::Error);

sub new {
  my ($class, $fs, $parent, $name, $children_order) = @_;

  my ($group_name, $iteration);
  
  $name =~ /\w+,([a-zA-Z_]+)(\d*)/;
  $group_name = $1;
  $iteration = $2;

  my @poss_member = keys %{$fs->{dferrors}};
  push @poss_member, keys %{$fs->{dferrors_carry}} if $fs->{dferrors_carry};
  my $field_sets;
  my @children;

  foreach (@poss_member) {
    my ($field_pattern, $group_pattern);
    if ($iteration) { #if we have a root group, then it is possible
                      #that we don't have an iteration
      $field_pattern = $group_name.'(\d+)::([a-zA-Z_])+$';
      $group_pattern = $iteration.'::'.$group_name.'(\d+)::[a-zA-Z_]+\d+';
    }
    else {
      $field_pattern = $group_name.'(\d+)::[a-zA-Z_]+$';
      $group_pattern = $group_name.'(\d+)::([a-zA-Z_])+\d+';
    }

    if (/$field_pattern/) { #we have a field
      my $index = $1;
      my $field = $fs->get_field($_);
      s/[a-zA-Z_]+\d+::([a-zA-Z_]+)/$1/;
      $field_sets->{$index}->{$_} = $field;
    }
    elsif (/$group_pattern/) { #we have a child
      push @children, {name => $1, iteration => $2};
    }
  }
  my @tmp_array = keys %$field_sets;
  my $tmp_key = pop @tmp_array;
  my $sample_fields =  $field_sets->{$tmp_key};
  my @field_order = keys %$sample_fields; #to provide a default

  foreach (@field_order) {
    s/[a-zA-Z_]+\d+::([a-zA-Z_]+)$/$1/;
  }

  my $this = $class->SUPER::new($fs, $parent, $field_sets, $name, '', \@field_order);

  #children order can be determined now
  my %child_order;
  my $counter = 0;

  if (@$children_order) { #an ordering has been provided
    foreach (@$children_order) {    
      $child_order{$_} = $counter++;
    }
    
    @children = 
      sort {
	if ($a->{name} eq $b->{name}) {
	  $a->{iteration} <=> $b->{iteration};
	}
	else {
	  $child_order{$a->{name}} <=> $child_order{$b->{name}};	
	}
      } @children;
    
    #we have to remove our stuff from the ordeirng

    my @new_order;
    my %handled;
    foreach (@children) { #this will not work as it ignores iteration
      if (!$handled{$_}) {
	my $name = $_->{name};
	
	foreach (@$children_order) {
	  if ($_ eq $name) {
	    #let it drop off
	  }
	  else {
	    push @new_order, $_;
	  }
	}

	$handled{$name} = 1;
      }
    }
  }
  else { #we must provide an ordeing of our own
    @children = 
      sort {
	if ($a->{name} eq $b->{name}) {
	  $a->{iteration} <=> $b->{iteration};
	}
	else {
	  $a->{name} cmp $b->{name};	
	}
      } @children;
  }

  my $child;
  foreach $child (@children) {
    my $child_name = $child->{name}.$child->{iteration};

    my $error_obj = new PSP::Error::Group($fs, $this, $child_name, $children_order);
  }

  return $this;
}

sub print_error_messages {
  my ($this, $disp_name) = @_;
  my $html = '';

  my $field_sets = $this->field_sets();

  my $set;
  foreach $set (@$field_sets) {
    $html .= print_default_set_messages($set, $disp_name);
  }

  return $html;
}

sub print_default_html {
  my ($this) = @_;
  my $html = '';

  my $field_sets = $this->field_sets();

  my $set;
  foreach $set (@$field_sets) {
    $html .= print_default_set_html($set);
  }

  return $html;
}

sub print_default_report {
  my ($this, $disp_name) = @_;

  my $html = '';

  my $field_sets = $this->field_sets();

  my $set;
  foreach $set (@$field_sets) {
    $html .= print_default_set_messages($set, $disp_name);
    $html .= '<br>';
    $html .= print_default_set_html($set);
  }

  return $html;
}


sub print_default_set_html {
  my ($set) = @_;
  my $html = '';
  my (@field_name, @input);

  my $field;
  foreach $field (@$set) {
    
    push @field_name, '<td>'.$field->{error_mod}->{textname}.'</td>';
    push @input, '<td>'.$field->html_input().'</td>';
  }
  
  $html .= '<tr>'."@field_name".'</tr>';
  $html .= '<tr>'."@input".'</tr>';

  return $html;
}

sub print_default_set_messages {
  my ($set, $disp_name) = @_;
  my $html = '';

  my $field;

  foreach $field (@$set) {
    my $mes;
    my $messages;
    #not everyone will have a message as some might be carried along
    if (defined($field) && ($messages = $field->error_messages())) {
      if ($disp_name) {
	$disp_name = $field->alias()." : ";
      }
      else {
	undef $disp_name;
      }

      foreach $mes (@{$messages}) {
	$html .= $disp_name.$mes.'<br>';
      }
    }
  }

  return $html;
}

sub isa {
  my ($this, $type) = @_;

  return ($type eq 'group');
}
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
