package localutils;
use strict;
use Config;

use Exporter;
use vars qw(@ISA @EXPORT);
BEGIN { 
 @ISA = qw(Exporter);
 @EXPORT = qw(parse_makefile_vars parse_PL_argv get_extra_libs
	      open_perl_script open_shell_script open_script close_script);
}

sub parse_makefile_vars {
  my $fname = "Makefile";
  -f $fname or $fname = "../Makefile";
  -f $fname or $fname = "../../Makefile";
  -f $fname or die "Error: could not find Makefile.\n";

  my %vars;
  open FILE, $fname or die "open: $fname: $!\n";
  while (<FILE>) {
    /^(\S+) = (.*)$/ and $vars{$1} = $2;
  }
  close FILE;

  return(\%vars);
}

sub parse_PL_argv {
  my (@argv) = @_;
  my ($fname,%init);
  for my $arg (@argv) {
    if ($arg =~ /^([^=]+)=(.*)$/) {
      $init{$1} = $2;
    } elsif (! $fname) {
      $fname = $arg;
    } else {
      die "invalid argument: $arg\n";
    }
  }
  # ExtUtils::MakeMaker 5.42 doesn't pass the name of desired script.
  if (!$fname) {
    my $appname = $1 if $0 =~ m!.*?([^/]+)\.PL$!;
    $appname or die "$0 does not end with .PL?\n";
    $fname = (-d "bin") ? "bin/$appname" : $appname;
  }
  return ($fname,\%init);
}

sub get_extra_libs {
  my ($vars,$init) = @_;

  my $prefix = $init->{PREFIX} || $vars->{PREFIX};
  my $libs = $init->{LIBS};
  if (! $libs) {
    my $key = "INSTALL".($vars->{INSTALLDIRS} eq "site"?"SITE":"PRIV")."LIB";
    $libs = $vars->{$key};
    $libs =~ s/\$\(PREFIX\)/$prefix/g;
    # don't do anything if we already have.
    my $key_lower = lc($key);
    undef $libs if $libs eq $Config{$key_lower};
  } 
  return("","") unless $libs;

  $libs =~ s/:/ /g;
  my $uses = $libs ? "use lib qw($libs);\n" : "";
  my @libs = split / /,$libs;
  my $args = @libs ? join("",map{"-I$_ "}@libs) : "";

  return ($uses,$args);
}

sub open_perl_script {
  my ($fname,@args) = @_;
  open_script($fname);
  @args and unshift @args, "";
  print($Config{startperl}.join(" ",@args)."\n".
	"# WARNING: This file was automatically generated.  ".
	"You may lose changes.\n");
}

sub open_shell_script {
  my ($fname,@args) = @_;
  open_script($fname);
  @args and unshift @args, "";
  print("#!/bin/sh".join(" ",@args)."\n",
	"# WARNING: This file was automatically generated.  ".
	"You may lose changes.\n");
}

my $script_fname;
sub open_script {
  $script_fname = shift;
  open OUT, ">$script_fname" or die "open: $script_fname: $!\n";
  select OUT;
}

sub close_script {
  close OUT;
  chmod 0755, $script_fname or die "chmod: $script_fname: $!\n";
}

1;
