package HTMLIO::PossibleSets;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: PossibleSets.pm,v 1.1 2000/11/23 23:36:16 muaddib Exp $

use strict;

=head1 NAME

HTMLIO::PossibleSets - defines lists for constraining possible AtomicData values

=head1 SYNOPSIS

  ...
  use HTMLIO::PossibleSets qw(:all);

  for my $key (@US_STATES) {
    print("$US_STATES{$key} is abbreviated '$key'\n");
  }

  print("Sorted non-US sovreignties are:\n".
	join("\n",@NON_US_SOVEREIGNTIES)."\n");

  print("Sorted sovereignty codes are:\n".
	join("\n",@SOVEREIGNTY_CODES)."\n");

  print("Domain extensions sorted by name:\n".
	join("\n",@DOMAIN_EXTENSION_ALPHA)."\n");

  ([qw(%US_STATES @US_STATE_ALPHA @US_STATE_CODES @US_STATES)],
   [qw(%NON_US_STATE @NON_US_STATE_ALPHA @NON_US_STATE_CODES 
       @NON_US_STATE)],
   [qw(%US_DISTRICTS @US_DISTRICT_ALPHA @US_DISTRICT_CODES 
       @US_DISTRICTS)],
   [qw(%US_TERRITORIES @US_TERRITORY_ALPHA @US_TERRITORY_CODES 
       @US_TERRITORIES)],
   [qw(%US_PROTECTORATES @US_PROTECTORATE_ALPHA @US_PROTECTORATE_CODES 
       @US_PROTECTORATES)],
   [qw(%US_MILITARY_DISTRICTS @US_MILITARY_DISTRICT_ALPHA 
       @US_MILITARY_DISTRICT_CODES @US_MILITARY_DISTRICTS)],
   [qw(%US_MAIL_ABBRS @US_MAIL_ABBR_ALPHA @US_MAIL_ABBR_CODES 
       @US_MAIL_ABBRS)],
   [qw(%US_CONCERNS @US_CONCERN_ALPHA @US_CONCERN_CODES 
       @US_CONCERNS)],
   [qw(%NON_US_SOVEREIGNTIES @NON_US_SOVEREIGNTY_ALPHA 
       @NON_US_SOVEREIGNTY_CODES @NON_US_SOVEREIGNTIES)],
   [qw(%SOVEREIGNTIES @SOVEREIGNTY_ALPHA @SOVEREIGNTY_CODES 
       @SOVEREIGNTIES)],
   [qw(%DOMAIN_EXTENSIONS @DOMAIN_EXTENSION_ALPHA @DOMAIN_EXTENSION_CODES 
       @DOMAIN_EXTENSIONS)]);

=head1 DESCRIPTION

Defines hashes for HTMLIO::Select and lists for everything else.

The sorted arrays sort off these elements: @US_STATE_ALPHA sorts by key
('TX'), @US_STATES sorts by value ('Texas')

=cut

use strict;
use Exporter;

use vars qw(@ISA @SETS @EXPORT_OK %EXPORT_TAGS);
@ISA = qw(Exporter);

# define the list of sets we will define in this module.
BEGIN {
  @SETS = 
    ([qw(%US_STATES @US_STATE_ALPHA @US_STATE_CODES @US_STATES)],
     [qw(%NON_US_STATE @NON_US_STATE_ALPHA @NON_US_STATE_CODES 
	 @NON_US_STATE)],
     [qw(%US_DISTRICTS @US_DISTRICT_ALPHA @US_DISTRICT_CODES 
	 @US_DISTRICTS)],
     [qw(%US_TERRITORIES @US_TERRITORY_ALPHA @US_TERRITORY_CODES 
	 @US_TERRITORIES)],
     [qw(%US_PROTECTORATES @US_PROTECTORATE_ALPHA @US_PROTECTORATE_CODES 
	 @US_PROTECTORATES)],
     [qw(%US_MILITARY_DISTRICTS @US_MILITARY_DISTRICT_ALPHA 
	 @US_MILITARY_DISTRICT_CODES @US_MILITARY_DISTRICTS)],
     [qw(%US_MAIL_ABBRS @US_MAIL_ABBR_ALPHA @US_MAIL_ABBR_CODES 
	 @US_MAIL_ABBRS)],
     [qw(%US_CONCERNS @US_CONCERN_ALPHA @US_CONCERN_CODES 
	 @US_CONCERNS)],
     [qw(%NON_US_SOVEREIGNTIES @NON_US_SOVEREIGNTY_ALPHA 
	 @NON_US_SOVEREIGNTY_CODES @NON_US_SOVEREIGNTIES)],
     [qw(%SOVEREIGNTIES @SOVEREIGNTY_ALPHA @SOVEREIGNTY_CODES 
	 @SOVEREIGNTIES)],
     [qw(%DOMAIN_EXTENSIONS @DOMAIN_EXTENSION_ALPHA @DOMAIN_EXTENSION_CODES 
	 @DOMAIN_EXTENSIONS)]);
  
  # assign the elements of these sets to @EXPORT_OK
  map { push @EXPORT_OK, @$_ } @SETS;

  %EXPORT_TAGS = ( 'all' => \@EXPORT_OK );
}

# declare all these variables.
use vars @EXPORT_OK;

BEGIN {
  # define the sets.
  %US_STATES = 
    ('AK' => 'Alaska',
     'AL' => 'Alabama',
     'AR' => 'Arkansas',
     'AZ' => 'Arizona',
     'CA' => 'California',
     'CO' => 'Colorado',                          
     'CT' => 'Connecticut',
     'DE' => 'Delaware',
     'FL' => 'Florida',
     'GA' => 'Georgia',
     'HI' => 'Hawaii',
     'IA' => 'Iowa',
     'ID' => 'Idaho',
     'IL' => 'Illinois',
     'IN' => 'Indiana',
     'KS' => 'Kansas',
     'KY' => 'Kentucky',
     'LA' => 'Louisiana', 
     'MA' => 'Massachusetts',
     'MD' => 'Maryland',
     'ME' => 'Maine',
     'MI' => 'Michigan',
     'MN' => 'Minnesota',
     'MO' => 'Missouri', 
     'MS' => 'Mississippi',
     'MT' => 'Montana',
     'NC' => 'North Carolina',
     'ND' => 'North Dakota',
     'NE' => 'Nebraska',
     'NH' => 'New Hampshire',
     'NJ' => 'New Jersey',
     'NM' => 'New Mexico',
     'NV' => 'Nevada',
     'NY' => 'New York',
     'OH' => 'Ohio',
     'OK' => 'Oklahoma',
     'OR' => 'Oregon',
     'PA' => 'Pennsylvania',
     'RI' => 'Rhode Island',
     'SC' => 'South Carolina',
     'SD' => 'South Dakota',
     'TN' => 'Tennessee',
     'TX' => 'Texas',
     'UT' => 'Utah',
     'VA' => 'Virginia',
     'VT' => 'Vermont',
     'WA' => 'Washington',
     'WI' => 'Wisconsin',
     'WV' => 'West Virginia',
     'WY' => 'Wyoming');
  
  %NON_US_STATE = 
    ('NA' => 'Non US State');
  
  %US_DISTRICTS = 
    ('DC' => 'District of Columbia');
  
  %US_TERRITORIES = 
    ('AS' => 'American Samoa',
     'GU' => 'Guam',
     'VI' => 'Virgin Islands',
     'MP' => 'Commonwealth of the Northern Mariana Islands');
  
  %US_PROTECTORATES = 
    ('FM' => 'Federated States of Micronesia',
     'MH' => 'Marshall Islands',
     'PR' => 'Puerto Rico',
     'PW' => 'Palau');
  
  %US_MILITARY_DISTRICTS = 
    ('AA' => 'Armed Forces America',
     'AE' => 'Armed Forces Europe',
     'AP' => 'Armed Forces Pacific');

  %US_MAIL_ABBRS = 
    (%US_STATES, 
     %US_DISTRICTS, 
     %US_MILITARY_DISTRICTS);

  %US_CONCERNS = 
    (%US_MAIL_ABBRS,
     %US_TERRITORIES, 
     %US_PROTECTORATES);

  %NON_US_SOVEREIGNTIES = 
    ('AD' => 'Andorra',
     'AE' => 'United Arab Emirates',
     'AF' => 'Afghanistan',
     'AG' => 'Antigua and Barbuda',
     'AI' => 'Anguilla',
     'AL' => 'Albania',
     'AM' => 'Armenia',
     'AN' => 'Netherlands Antilles',
     'AO' => 'Angola',
     'AQ' => 'Antarctica',
     'AR' => 'Argentina',
     'AS' => 'American Samoa',
     'AT' => 'Austria',
     'AU' => 'Australia',
     'AW' => 'Aruba',
     'AZ' => 'Azerbaidjan',
     'BA' => 'Bosnia-Herzegovina',
     'BB' => 'Barbados',
     'BD' => 'Bangladesh',
     'BE' => 'Belgium',
     'BF' => 'Burkina Faso',
     'BG' => 'Bulgaria',
     'BH' => 'Bahrain',
     'BI' => 'Burundi',
     'BJ' => 'Benin',
     'BM' => 'Bermuda',
     'BN' => 'Brunei Darussalam',
     'BO' => 'Bolivia',
     'BR' => 'Brazil',
     'BS' => 'Bahamas',
     'BT' => 'Bhutan',
     'BV' => 'Bouvet Island',
     'BW' => 'Botswana',
     'BY' => 'Belarus',
     'BZ' => 'Belize',
     'CA' => 'Canada',
     'CC' => 'Cocos (Keeling) Islands',
     'CF' => 'Central African Republic',
     'CG' => 'Congo',
     'CH' => 'Switzerland',
     'CI' => 'Ivory Coast (Cote D\'Ivoire)',
     'CK' => 'Cook Islands',
     'CL' => 'Chile',
     'CM' => 'Cameroon',
     'CN' => 'China',
     'CO' => 'Colombia',
     'CR' => 'Costa Rica',
     'CS' => 'Former Czechoslovakia',
     'CU' => 'Cuba',
     'CV' => 'Cape Verde',
     'CX' => 'Christmas Island',
     'CY' => 'Cyprus',
     'CZ' => 'Czech Republic',
     'DE' => 'Germany',
     'DJ' => 'Djibouti',
     'DK' => 'Denmark',
     'DM' => 'Dominica',
     'DO' => 'Dominican Republic',
     'DZ' => 'Algeria',
     'EC' => 'Ecuador',
     'EE' => 'Estonia',
     'EG' => 'Egypt',
     'EH' => 'Western Sahara',
     'ES' => 'Spain',
     'ET' => 'Ethiopia',
     'FI' => 'Finland',
     'FJ' => 'Fiji',
     'FK' => 'Falkland Islands',
     'FM' => 'Micronesia',
     'FO' => 'Faroe Islands',
     'FR' => 'France',
     'FX' => 'France (European Territory)',
     'GA' => 'Gabon',
     'GD' => 'Grenada',
     'GE' => 'Georgia',
     'GF' => 'French Guyana',
     'GH' => 'Ghana',
     'GI' => 'Gibraltar',
     'GL' => 'Greenland',
     'GM' => 'Gambia',
     'GN' => 'Guinea',
     'GP' => 'Guadeloupe (French)',
     'GQ' => 'Equatorial Guinea',
     'GR' => 'Greece',
     'GS' => 'S. Georgia & S. Sandwich Isls.',
     'GT' => 'Guatemala',
     'GU' => 'Guam (USA)',
     'GW' => 'Guinea Bissau',
     'GY' => 'Guyana',
     'HK' => 'Hong Kong',
     'HM' => 'Heard and McDonald Islands',
     'HN' => 'Honduras',
     'HR' => 'Croatia',
     'HT' => 'Haiti',
     'HU' => 'Hungary',
     'ID' => 'Indonesia',
     'IE' => 'Ireland',
     'IL' => 'Israel',
     'IN' => 'India',
     'IO' => 'British Indian Ocean Territory',
     'IQ' => 'Iraq',
     'IR' => 'Iran',
     'IS' => 'Iceland',
     'IT' => 'Italy',
     'JM' => 'Jamaica',
     'JO' => 'Jordan',
     'JP' => 'Japan',
     'KE' => 'Kenya',
     'KG' => 'Kyrgyzstan',
     'KH' => 'Cambodia',
     'KI' => 'Kiribati',
     'KM' => 'Comoros',
     'KN' => 'Saint Kitts & Nevis Anguilla',
     'KP' => 'North Korea',
     'KR' => 'South Korea',
     'KW' => 'Kuwait',
     'KY' => 'Cayman Islands',
     'KZ' => 'Kazakhstan',
     'LA' => 'Laos',
     'LB' => 'Lebanon',
     'LC' => 'Saint Lucia',
     'LI' => 'Liechtenstein',
     'LK' => 'Sri Lanka',
     'LR' => 'Liberia',
     'LS' => 'Lesotho',
     'LT' => 'Lithuania',
     'LU' => 'Luxembourg',
     'LV' => 'Latvia',
     'LY' => 'Libya',
     'MA' => 'Morocco',
     'MC' => 'Monaco',
     'MD' => 'Moldavia',
     'MG' => 'Madagascar',
     'MH' => 'Marshall Islands',
     'MK' => 'Macedonia',
     'ML' => 'Mali',
     'MM' => 'Myanmar',
     'MN' => 'Mongolia',
     'MO' => 'Macau',
     'MP' => 'Northern Mariana Islands',
     'MQ' => 'Martinique (French)',
     'MR' => 'Mauritania',
     'MS' => 'Montserrat',
     'MT' => 'Malta',
     'MU' => 'Mauritius',
     'MV' => 'Maldives',
     'MW' => 'Malawi',
     'MX' => 'Mexico',
     'MY' => 'Malaysia',
     'MZ' => 'Mozambique',
     'NA' => 'Namibia',
     'NC' => 'New Caledonia (French)',
     'NE' => 'Niger',
     'NF' => 'Norfolk Island',
     'NG' => 'Nigeria',
     'NI' => 'Nicaragua',
     'NL' => 'Netherlands',
     'NO' => 'Norway',
     'NP' => 'Nepal',
     'NR' => 'Nauru',
     'NT' => 'Neutral Zone',
     'NU' => 'Niue',
     'NZ' => 'New Zealand',
     'OM' => 'Oman',
     'PA' => 'Panama',
     'PE' => 'Peru',
     'PF' => 'Polynesia (French)',
     'PG' => 'Papua New Guinea',
     'PH' => 'Philippines',
     'PK' => 'Pakistan',
     'PL' => 'Poland',
     'PM' => 'Saint Pierre and Miquelon',
     'PN' => 'Pitcairn Island',
     'PR' => 'Puerto Rico',
     'PT' => 'Portugal',
     'PW' => 'Palau',
     'PY' => 'Paraguay',
     'QA' => 'Qatar',
     'RE' => 'Reunion (French)',
     'RO' => 'Romania',
     'RU' => 'Russian Federation',
     'RW' => 'Rwanda',
     'SA' => 'Saudi Arabia',
     'SB' => 'Solomon Islands',
     'SC' => 'Seychelles',
     'SD' => 'Sudan',
     'SE' => 'Sweden',
     'SG' => 'Singapore',
     'SH' => 'Saint Helena',
     'SI' => 'Slovenia',
     'SJ' => 'Svalbard and Jan Mayen Islands',
     'SK' => 'Slovak Republic',
     'SL' => 'Sierra Leone',
     'SM' => 'San Marino',
     'SN' => 'Senegal',
     'SO' => 'Somalia',
     'SR' => 'Suriname',
     'ST' => 'Saint Tome and Principe',
     'SU' => 'Former USSR',
     'SV' => 'El Salvador',
     'SY' => 'Syria',
     'SZ' => 'Swaziland',
     'TC' => 'Turks and Caicos Islands',
     'TD' => 'Chad',
     'TF' => 'French Southern Territories',
     'TG' => 'Togo',
     'TH' => 'Thailand',
     'TJ' => 'Tadjikistan',
     'TK' => 'Tokelau',
     'TM' => 'Turkmenistan',
     'TN' => 'Tunisia',
     'TO' => 'Tonga',
     'TP' => 'East Timor',
     'TR' => 'Turkey',
     'TT' => 'Trinidad and Tobago',
     'TV' => 'Tuvalu',
     'TW' => 'Taiwan',
     'TZ' => 'Tanzania',
     'UA' => 'Ukraine',
     'UG' => 'Uganda',
     'UK' => 'United Kingdom',
     'UM' => 'USA Minor Outlying Islands',
     'UY' => 'Uruguay',
     'UZ' => 'Uzbekistan',
     'VA' => 'Vatican City State',
     'VC' => 'Saint Vincent & Grenadines',
     'VE' => 'Venezuela',
     'VG' => 'Virgin Islands (British)',
     'VI' => 'Virgin Islands (USA)',
     'VN' => 'Vietnam',
     'VU' => 'Vanuatu',
     'WF' => 'Wallis and Futuna Islands',
     'WS' => 'Samoa',
     'YE' => 'Yemen',
     'YT' => 'Mayotte',
     'YU' => 'Yugoslavia',
     'ZA' => 'South Africa',
     'ZM' => 'Zambia',
     'ZR' => 'Zaire',
     'ZW' => 'Zimbabwe');
  
  %SOVEREIGNTIES = 
    ( %NON_US_SOVEREIGNTIES, 
      ('US' => 'United States') );

  %DOMAIN_EXTENSIONS = 
    ( %SOVEREIGNTIES, 
      ('ARPA' => 'Old style Arpanet',
       'COM'  => 'USA Commercial',
       'EDU'  => 'USA Educational',
       'GOV'  => 'USA Government',
       'INT'  => 'International',
       'MIL'  => 'USA Military',
       'NATO' => 'NATO',
       'NET'  => 'Network',
       'ORG'  => 'Non-Profit Making Organisations',
       'GB'   => 'Great Britain') );
}
  
# define a routine to do these repetitive assignments.
sub sort_set {
  my ($hash_var,$alpha,$codes,$list) = @_;
  my $hash; 
  eval '$hash = \\'.$hash_var;
  eval $alpha . ' = sort {$hash->{$a} cmp $hash->{$b}} keys %$hash';
  eval $codes . ' = sort keys %$hash';
  eval $list  . ' = sort values %$hash';
}

# perform this repetitive operation on all the sets.
BEGIN { map { sort_set(@$_) } @SETS }

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
