# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: share.t,v 1.2 2000/11/27 09:18:49 muaddib Exp $

use strict;
use Test;
use Data::Dumper;
use PSP::share;
use PSP::parent;

package Share::Test;
BEGIN { @Share::Test::ISA = qw(PSP::share); }

package Share::Parent;
BEGIN { @Share::Parent::ISA = qw(PSP::parent PSP::share); }

package main;

my $n_iterations = 1;
plan tests => $n_iterations * 69;

my ($share,$test1,$test2,$parent,$child,$gchild);
for (my $i=0; $i < $n_iterations; $i++) {

ok $share = PSP::share->new();

ok $There::Package::this = "before sharing";
ok $Here::Package::this = "good";

ok $There::Package::this eq "before sharing";
ok $share->share(['$this'],'Here::Package','There::Package');
ok $There::Package::this eq "good";
ok \$There::Package::this eq \$Here::Package::this;
ok $share->unshare(undef,'There::Package');
ok \$There::Package::this ne \$Here::Package::this;

ok $Here::Package::this eq "good";
ok $There::Package::this eq "before sharing";

ok $share->dest_share_class("There::Package");
ok $share->source_share_class("Here::Package");
ok $share->expect('$this');

ok $There::Package::this eq "before sharing";
ok $share->share();
ok $There::Package::this eq "good";
ok \$There::Package::this eq \$Here::Package::this;
ok $share->unshare();
ok \$There::Package::this ne \$Here::Package::this;

ok $Here::Package::this eq "good";
ok $There::Package::this eq "before sharing";


ok $test1 = Share::Test->new();
ok $test2 = Share::Test->new();
ok $test1->dest_share_class("Here::Package");
ok $test2->dest_share_class("There::Package");

ok $test1->dest_share_class() eq "Here::Package";
ok $test2->dest_share_class() eq "There::Package";

ok !$test1->provide();
ok $test1->provide(qw($this));
ok $test2->expect(qw($this));

ok \$There::Package::this ne \$Here::Package::this;
ok $There::Package::this eq "before sharing";

ok $test2->share(undef,$test1);

ok \$There::Package::this eq \$Here::Package::this;
ok $There::Package::this eq "good";

ok $test2->unshare();

ok \$There::Package::this ne \$Here::Package::this;
ok $There::Package::this eq "before sharing";

ok $test2->share(undef,$test1);

ok \$There::Package::this eq \$Here::Package::this;
ok $There::Package::this eq "good";

undef $test2; # (DESTROY should be called here?)

ok \$There::Package::this ne \$Here::Package::this;
ok $There::Package::this eq "before sharing";

ok $parent = Share::Parent->new();
ok $child = $parent->new();
ok $gchild = $child->new();

ok @Foo::bat = qw(first second);
ok $Foo::ball = "home";

ok $parent->provide('@bat','$ball');
ok $parent->dest_share_class("Foo");

ok $child->expect('@bat','$ball');
ok $child->provide('@bat');
ok $child->dest_share_class("Bar");

ok $gchild->expect('@bat');
ok $gchild->dest_share_class("Baz");

ok !$parent->share();
ok $child->share();
ok $gchild->share();

ok @Baz::bat == 2;
ok join(",",@Baz::bat) eq "first,second";
ok \@Baz::bat eq \@Bar::bat;
ok \@Bar::bat eq \@Foo::bat;
ok !defined $Baz::ball;
ok \$Bar::ball eq \$Foo::ball;

$parent->unshare();

ok @Baz::bat == 0;
ok \@Baz::bat ne \@Bar::bat;
ok \@Bar::bat ne \@Foo::bat;
ok \$Bar::ball ne \$Foo::ball;

$parent->free();
}
