/****************************************************************************
** servicesdlg.h - a dialog for browsing Jabber services/agents/transports
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef SERVICESDLG_H
#define SERVICESDLG_H

#include<qwidget.h>
#include<qpixmap.h>
#include<qlistbox.h>
#include<qlabel.h>
#include<qlineedit.h>
#include<qptrlist.h>
#include"ui_services.h"
#include"jabcommon.h"
#include"userlist.h"
#include"uniquewindow.h"
#include"busywidget.h"

#define SERVICESDLG_ACT_REGISTER 0
#define SERVICESDLG_ACT_SEARCH   1


class ServicesDlg : public ServicesUI
{
	Q_OBJECT
public:
	ServicesDlg(int localStatus, QWidget *parent=0, const char *name=0);
	~ServicesDlg();

	static ServicesDlg *find();

protected:
	void closeEvent(QCloseEvent *);

signals:
	void signalRefresh(QString *id);
	void signalSearch(const QString &, QString *id);
	void signalGetRegForm(const QString &, QString *id);
	void signalCancelTransaction(const QString &);

public slots:
	void doRefresh();

	void loadSuccess(JabRoster *);
	void loadFail();

	void loadFormSuccess();
	void loadFormFail();

	void localUpdate(const JabRosterEntry &);

private slots:
	void serviceSelected(int);
	void serviceRegister();
	void serviceSearch();
	void doubleClicked(QListBoxItem *i);

private:
	void restoreWidgets();

	int localStatus;
	bool isBusy;
	BusyWidget *busy;

	JabRoster servicesList;

	QString regname, id;
	int actionType;
};


class RegistrationDlg : public QDialog, public UniqueWindow
{
	Q_OBJECT
public:
	RegistrationDlg(const JabForm &, QWidget *parent=0, const char *name=0);

	static RegistrationDlg *find(const QString &);

protected:
	// reimplemented
	void closeEvent(QCloseEvent *);

signals:
	void signalSubmitForm(const JabForm &, QString *id);

public slots:
	void putRegFormResponse(bool, const QString &err);
	void localUpdate(const JabRosterEntry &);

private slots:
	void doRegSubmit();

private:
	BusyWidget *busy;
	QPushButton *pb_register, *pb_close;

	QPtrList<QLabel> lb_field;
	QPtrList<QLineEdit> le_field;

	JabForm form;

	QString id;
	bool isBusy;
};

#endif

