/****************************************************************************
** searchdlg.h - a dialog for searching for Jabber contacts
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#include<qwidget.h>
#include<qlabel.h>
#include<qlineedit.h>
#include<qptrlist.h>
#include"jabcommon.h"
#include"ui_search.h"
#include"uniquewindow.h"
#include"userlist.h"
#include"busywidget.h"


class SearchDlg : public SearchUI, public UniqueWindow
{
	Q_OBJECT
public:
	SearchDlg(const QString &jid, const JabForm &, int localStatus, QWidget *parent=0, const char *name=0);
	~SearchDlg();

	static SearchDlg *find(const QString &);

protected:
	void closeEvent(QCloseEvent *);

signals:
	void signalSubmitForm(const JabForm &, QString *id);
	void signalCancelTransaction(const QString &);
	void aInfo(const QString &);
	void aAdd(const QString &, const QString &, const QString &);

public slots:
	void doSubmitForm();
	void putSearchFormResponse(JabRoster *);
	void localUpdate(const JabRosterEntry &);

private slots:
	void doStop();
	void selectionChanged();
	void doAdd();
	void doInfo();

private:
	void addEntry(const QString &jid, const QString &nick, const QString &first, const QString &last, const QString &email);
	void clear();

	QString v_jid;
	JabForm form;
	int localStatus;

	bool isBusy;
	BusyWidget *busy;
	QString id;

	QPtrList<QLabel> lb_field;
	QPtrList<QLineEdit> le_field;
};

#endif
