/****************************************************************************
** optionsdlg.cpp - the preferences dialog
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

// default cvlist font?  "Helvetica,10,5,50,0,0,0,0,0"

#include"optionsdlg.h"
#include"common.h"
#include"idle.h"

#include<qcolordialog.h>
#include<qfontdialog.h>
#include<qcheckbox.h>
#include<qcombobox.h>
#include<qlineedit.h>
#include<qlistbox.h>
#include<qinputdialog.h>
#include<qspinbox.h>
#include<qfiledialog.h>
#include<qdir.h>
#include<qlabel.h>

#include"eventdlg.h"
#include"chatdlg.h"


static OptionsDlg *options_ptr = 0;

OptionsDlg::OptionsDlg(const Options &_opt, QWidget *parent, const char *name)
:OptionsUI(parent, name, FALSE, WDestructiveClose)
{
	int n;

	setCaption(CAP(tr("Options")));

	opt = _opt;
	options_ptr = this;

	// General : Roster
	ck_useleft->setChecked(opt.useleft);
	ck_singleclick->setChecked(opt.singleclick);

	bg_defAct = new QButtonGroup;
	bg_defAct->setRadioButtonExclusive(TRUE);
	bg_defAct->insert(rb_defActMsg, 0);
	bg_defAct->insert(rb_defActChat, 1);
	bg_defAct->setButton(opt.defaultAction);

	// General : Misc
#ifdef Q_WS_MAC
	ck_alwaysOnTop->setEnabled(FALSE);
#else
	ck_alwaysOnTop->setChecked(opt.alwaysOnTop);
#endif

	bg_delChats = new QButtonGroup;
	bg_delChats->setRadioButtonExclusive(TRUE);
	bg_delChats->insert(rb_delChatsClose, 0);
	bg_delChats->insert(rb_delChatsHour, 1);
	bg_delChats->insert(rb_delChatsDay, 2);
	bg_delChats->insert(rb_delChatsNever, 3);
	bg_delChats->setButton(opt.delChats);

	ck_keepSizes->setChecked(opt.keepSizes);

	// General : Links
#ifdef Q_WS_WIN
	cb_link->insertItem(tr("Windows Default Browser/Mail"));
#endif
#ifdef Q_WS_X11
	cb_link->insertItem(tr("KDE Default Browser/Mail"));
#endif
#ifdef Q_WS_MAC
	cb_link->insertItem(tr("MacOS Default Browser/Mail"));
#endif
#if !defined(Q_WS_MAC)
	cb_link->insertItem(tr("Custom"));
#endif
	connect(cb_link, SIGNAL(activated(int)), this, SLOT(selectBrowser(int)));
	cb_link->setCurrentItem(opt.browser);
	selectBrowser(opt.browser);
	le_linkBrowser->setText(opt.customBrowser);
	le_linkMailer->setText(opt.customMailer);

	// General : Docking
	ck_docklet->setChecked(opt.useDock);
	ck_dockDCstyle->setChecked(opt.dockDCstyle);
	connect(ck_docklet, SIGNAL(toggled(bool)), ck_dockDCstyle, SLOT(setEnabled(bool)));
	if(!ck_docklet->isChecked())
		ck_dockDCstyle->setEnabled(FALSE);

#ifdef Q_WS_MAC
	gb_docking->setEnabled(FALSE);
#endif

	// Look and Feel : Colors
	bg_color = new QButtonGroup;
	bg_color->insert(pb_cOnline, 0);
	bg_color->insert(pb_cOffline, 1);
	bg_color->insert(pb_cAway, 2);
	bg_color->insert(pb_cDND, 3);
	bg_color->insert(pb_cGroupFore, 4);
	bg_color->insert(pb_cGroupBack, 5);
	bg_color->insert(pb_cListBack, 6);
	for(n = 0; n < 7; ++n) {
		showColor((QPushButton *)bg_color->find(n), opt.color[n]);
	}
	connect(bg_color, SIGNAL(clicked(int)), this, SLOT(chooseColor(int)));

	// Look and Feel : Fonts
	le_font[0] = le_fRoster;
	le_font[1] = le_fMessage;
	le_font[2] = le_fChat;
	for(n = 0; n < 3; ++n) {
		le_font[n]->setText(opt.font[n]);
	}
	bg_font = new QButtonGroup;
	bg_font->insert(pb_fRoster, 0);
	bg_font->insert(pb_fMessage, 1);
	bg_font->insert(pb_fChat, 2);
	connect(bg_font, SIGNAL(clicked(int)), this, SLOT(chooseFont(int)));

	// Look and Feel : Icon Set
	QStringList descriptions;
	getPsiIconSets(iconsets, descriptions);
	cb_iconset->insertStringList(descriptions);
	n = qstringlistmatch(iconsets, opt.iconset);
	cb_iconset->setCurrentItem(n);
	connect(cb_iconset, SIGNAL(activated(int)), this, SLOT(selectIconSet(int)));

	// Events : Receive
	ck_popupMsgs->setChecked(opt.popupMsgs);
	ck_popupChats->setChecked(opt.popupChats);
	ck_raise->setChecked(opt.raise);
	cb_incomingAs->setCurrentItem(opt.incomingAs);

	// Events : Send
	cb_outgoingAs->setCurrentItem(opt.outgoingAs);

	// Events : Alerts
	bg_alerts->setButton(opt.alertStyle);
	connect(bg_alerts, SIGNAL(clicked(int)), this, SLOT(selectAlertStyle(int)));

	// Events : Misc
	ck_ignoreHeadline->setChecked(opt.ignoreHeadline);
	ck_scrollTo->setChecked(opt.scrollTo);

	// Presence : Misc
	ck_askOnline->setChecked(opt.askOnline);
	ck_rosterAnim->setChecked(opt.rosterAnim);

	// Presence : Auto Status
	sb_asAway->setMinValue(0);
	sb_asAway->setValue(opt.asAway);
	sb_asXa->setMinValue(0);
	sb_asXa->setValue(opt.asXa);
	sb_asOffline->setMinValue(0);
	sb_asOffline->setValue(opt.asOffline);
	if(!Idle::isSupported())
		gb_autoStatus->setEnabled(FALSE);

	// Presence : Status Presets
	pb_spNew->setEnabled(TRUE);
	pb_spDelete->setEnabled(FALSE);
	te_sp->setEnabled(FALSE);
	connect(pb_spNew, SIGNAL(clicked()), this, SLOT(newStatusPreset()));
	connect(pb_spDelete, SIGNAL(clicked()), this, SLOT(removeStatusPreset()));
	connect(te_sp, SIGNAL(textChanged()), this, SLOT(changeStatusPreset()));
	connect(lb_sp, SIGNAL(highlighted(int)), this, SLOT(selectStatusPreset(int)));
	lb_sp->insertStringList(opt.sp.varsToStringList());
	if(lb_sp->count() >= 1)
		lb_sp->setSelected(0, TRUE);

	// Sound : Preferences
#if defined(Q_WS_WIN)
	lb_player->setEnabled(FALSE);
	le_player->setText(tr("Windows Sound"));
	le_player->setEnabled(FALSE);
#elif defined(Q_WS_MAC)
	lb_player->setEnabled(FALSE);
	le_player->setText(tr("MacOS Sound"));
	le_player->setEnabled(FALSE);
#else
	le_player->setText(opt.player);
#endif
	ck_noAwaySound->setChecked(opt.noAwaySound);

	// Sound : Events
	le_oe[0] = le_oeMessage;
	le_oe[1] = le_oeChat1;
	le_oe[2] = le_oeChat2;
	le_oe[3] = le_oeSystem;
	le_oe[4] = le_oeOnline;
	le_oe[5] = le_oeOffline;
	le_oe[6] = le_oeSend;
	for(n = 0; n < 7; ++n)
		le_oe[n]->setText(opt.onevent[n]);
	bg_oe = new QButtonGroup;
	bg_oe->insert(pb_oeMessage, 0);
	bg_oe->insert(pb_oeChat1, 1);
	bg_oe->insert(pb_oeChat2, 2);
	bg_oe->insert(pb_oeSystem, 3);
	bg_oe->insert(pb_oeOnline, 4);
	bg_oe->insert(pb_oeOffline, 5);
	bg_oe->insert(pb_oeSend, 6);
	connect(bg_oe, SIGNAL(clicked(int)), this, SLOT(chooseOnEvent(int)));

	connect(pb_soundReset, SIGNAL(clicked()), this, SLOT(soundReset()));

	connect(buttonApply, SIGNAL(clicked()), this, SLOT(apply()));
	buttonApply->setEnabled(FALSE);
	dirty = FALSE;
	noDirty = FALSE;

	resize(sizeHint());
}

OptionsDlg::~OptionsDlg()
{
	delete bg_defAct;
	delete bg_color;
	delete bg_font;
	delete bg_oe;

	options_ptr = 0;
}

/* static */ OptionsDlg *OptionsDlg::find()
{
	return options_ptr;
}

void OptionsDlg::accept()
{
	doApplyOptions();

	QDialog::accept();
}

void OptionsDlg::doApplyOptions()
{
	opt.useleft = ck_useleft->isChecked();
	opt.singleclick = ck_singleclick->isChecked();
	opt.defaultAction = bg_defAct->id(bg_defAct->selected());
	opt.delChats = bg_delChats->id(bg_delChats->selected());
	opt.browser = cb_link->currentItem();
	opt.alwaysOnTop = ck_alwaysOnTop->isChecked();
	opt.rosterAnim = ck_rosterAnim->isChecked();

	opt.useDock = ck_docklet->isChecked();
	opt.dockDCstyle = ck_dockDCstyle->isChecked();

	opt.customBrowser = le_linkBrowser->text();
	opt.customMailer = le_linkMailer->text();

	opt.popupMsgs = ck_popupMsgs->isChecked();
	opt.popupChats = ck_popupChats->isChecked();
	opt.raise = ck_raise->isChecked();
	opt.incomingAs = cb_incomingAs->currentItem();
	opt.outgoingAs = cb_outgoingAs->currentItem();

	opt.askOnline = ck_askOnline->isChecked();

	opt.asAway = sb_asAway->value();
	opt.asXa = sb_asXa->value();
	opt.asOffline = sb_asOffline->value();

	opt.player = le_player->text();
	opt.noAwaySound = ck_noAwaySound->isChecked();

	opt.keepSizes = ck_keepSizes->isChecked();
	opt.ignoreHeadline = ck_ignoreHeadline->isChecked();
	opt.scrollTo = ck_scrollTo->isChecked();

	// restore the default sizes
	if(!opt.keepSizes) {
		opt.sizeEventDlg = EventDlg::defaultSize();
		opt.sizeChatDlg = ChatDlg::defaultSize();
	}

	for(int n = 0; n < 7; ++n)
		opt.onevent[n] = le_oe[n]->text();

	applyOptions(opt);
}

void OptionsDlg::showColor(QPushButton *pb, QColor c)
{
	QPixmap p(22, 10);
	p.fill(c);
	pb->setPixmap(p);
}

void OptionsDlg::chooseFont(int x)
{
	bool ok;
	QFont font;
	font.fromString(opt.font[x]);

	opt.font[x] = QFontDialog::getFont(&ok, font, this).toString();
	le_font[x]->setText(opt.font[x]);

	if(ok)
		dataChanged();
}

void OptionsDlg::chooseColor(int x)
{
	QColor c = opt.color[x];

	c = QColorDialog::getColor(c, this);
	if(c.isValid()) {
		opt.color[x] = c;
		showColor((QPushButton *)bg_color->find(x), opt.color[x]);

		dataChanged();
	}
}

void OptionsDlg::selectIconSet(int x)
{
	opt.iconset = qstringlistlookup(iconsets, x);
}

void OptionsDlg::selectAlertStyle(int x)
{
	opt.alertStyle = x;
}

void OptionsDlg::selectStatusPreset(int x)
{
	if(x == -1) {
		pb_spDelete->setEnabled(FALSE);
		noDirty = TRUE;
		te_sp->setText("");
		te_sp->setEnabled(FALSE);
		noDirty = FALSE;
		return;
	}

	noDirty = TRUE;

	pb_spDelete->setEnabled(TRUE);

	te_sp->setText(opt.sp.get(lb_sp->text(x)));
	te_sp->setEnabled(TRUE);

	noDirty = FALSE;
}

void OptionsDlg::newStatusPreset()
{
	QString text;

	while(1) {
		bool ok = FALSE;
		text = QInputDialog::getText(
			CAP(tr("New Status Preset")),
			tr("Please enter a name for the new status preset:"),
			QLineEdit::Normal, text, &ok, this);
		if(!ok)
			return;

		if(text.isEmpty())
			QMessageBox::information(this, tr("Error"), tr("Can't create a blank preset!"));
		else if(opt.sp.findByKey(text) != opt.sp.end())
			QMessageBox::information(this, tr("Error"), tr("You already have a preset with that name!"));
		else
			break;
	}

	opt.sp.set(text, "");
	lb_sp->insertItem(text);
	lb_sp->setSelected(lb_sp->count()-1, TRUE);
	te_sp->setFocus();

	dataChanged();
}

void OptionsDlg::removeStatusPreset()
{
	int id = lb_sp->currentItem();
	if(id == -1)
		return;

	dataChanged();

	opt.sp.unset(lb_sp->text(id));
	lb_sp->removeItem(id);

	// select a new entry if possible
	if(lb_sp->count() == 0) {
		selectStatusPreset(-1);
		return;
	}

	if(id >= (int)lb_sp->count())
		id = lb_sp->count()-1;

	lb_sp->setSelected(id, TRUE);
	selectStatusPreset(id);
}

void OptionsDlg::changeStatusPreset()
{
	int id = lb_sp->currentItem();
	if(id == -1)
		return;

	opt.sp.set(lb_sp->text(id), te_sp->text());
	dataChanged();
}

void OptionsDlg::chooseOnEvent(int x)
{
	QString str = QFileDialog::getOpenFileName(QDir::homeDirPath(), "Sound (*.wav)", this, "", "Choose a sound file");
	if(!str.isEmpty()) {
		le_oe[x]->setText(str);
		dataChanged();
	}
}

void OptionsDlg::soundReset()
{
	opt.onevent[eMessage] = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eChat1]   = g.pathBase + "/sound/chat1.wav";
	opt.onevent[eChat2]   = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eSystem]  = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eOnline]  = g.pathBase + "/sound/online.wav";
	opt.onevent[eOffline] = g.pathBase + "/sound/offline.wav";
	opt.onevent[eSend]    = g.pathBase + "/sound/send.wav";

	for(int n = 0; n < 7; ++n)
		le_oe[n]->setText(opt.onevent[n]);

	dataChanged();
}

void OptionsDlg::dataChanged()
{
	if(noDirty)
		return;

	dirty = TRUE;
	buttonApply->setEnabled(TRUE);
}

void OptionsDlg::apply()
{
	doApplyOptions();

	dirty = FALSE;
	buttonApply->setEnabled(FALSE);
}

void OptionsDlg::selectBrowser(int x)
{
	bool enableCustom = TRUE;

#ifdef Q_WS_WIN
	if(x == 0)
		enableCustom = FALSE;
#endif
#ifdef Q_WS_X11
	if(x == 0)
		enableCustom = FALSE;
#endif
#ifdef Q_WS_MAC
	if(x == 0)
		enableCustom = FALSE;
#endif

	gb_linkCustom->setEnabled(enableCustom);
}

