/****************************************************************************
** offermaindlg.cpp - a dialog for managing offerred files
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"offermaindlg.h"
#include"common.h"


static OfferMainDlg *offermain_ptr = 0;

OfferMainDlg::OfferMainDlg(QWidget *parent, const char *name)
:OfferMainUI(parent, name, WDestructiveClose)
{
	setCaption(CAP(tr("File Sharing")));
	offermain_ptr = this;
}

OfferMainDlg::~OfferMainDlg()
{
	offermain_ptr = 0;
}

/* static */ OfferMainDlg *OfferMainDlg::find()
{
	return offermain_ptr;
}

void OfferMainDlg::slotNewOffer(FileServerItem *fi)
{
	addItem(fi->file.fileName(), fi->file.size(), fi->who);
}

void OfferMainDlg::addItem(const QString &fname, int size, const QString &who)
{
	OfferItem *lvi = new OfferItem(lv_main);
	lvi->setText(0, fname);
	lvi->setText(1, QString("%1").arg(size));
	lvi->setText(2, who);
	if(lvi->state == 0)
		lvi->setText(3, "Waiting for response");
}


OfferItem::OfferItem(QListView *par)
:QListViewItem(par)
{
	state = 0;
}
