/****************************************************************************
** message.h - messages and history
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef MESSAGE_H
#define MESSAGE_H

#include<qstring.h>
#include<qfile.h>
#include<qtextstream.h>
#include<qdatetime.h>

#define MESSAGE_NORM     0
#define MESSAGE_CHAT     1
#define MESSAGE_SYS      2
#define MESSAGE_AUTHREQ  3
#define MESSAGE_ERROR    4
#define MESSAGE_HEADLINE 5

#define HISTORY_NONE    0
#define HISTORY_READ    1
#define HISTORY_WRITE   2
#define HISTORY_FLAG    3


class Message
{
public:
	Message();

	QString to, from, text, subject;
	QString url, url_desc;
	int type;
	QDateTime timeStamp;
	bool originLocal;
	bool late;

	bool unread;
};

class MessageHistory
{
public:
	MessageHistory(const QString &jid, int mode);
	~MessageHistory();

	Message *readEntry();
	void writeEntry(const Message &msg);

	Message *readCurrent();
	void stepForward();
	void stepBack();
	void setFlagsCurrent(const QString &);

private:
	int mode;
	QFile f;
	QString v_jid;

	Message *parseLine(const QString &line);
};

#endif
